/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.util.error.analysers.impl;

import dev.pumpo5.core.util.error.ErrorType;
import dev.pumpo5.core.util.error.analysers.ErrorAnalyser;
import org.openqa.selenium.NoSuchSessionException;

public class KafkaTimeoutExceptionAnalyser
implements ErrorAnalyser {
    private static final String KAFKA_TIMEOUT_EXCEPTION = "org.apache.kafka.common.errors.TimeoutException";

    @Override
    public ErrorType analyse(Throwable e) {
        while (e != null) {
            if (e.getClass().equals(NoSuchSessionException.class) || e.getMessage() != null && e.getMessage().contains(KAFKA_TIMEOUT_EXCEPTION)) {
                return ErrorType.KAFKA_TIMEOUT_EXCEPTION_PARTITION;
            }
            e = e.getCause();
        }
        return ErrorType.DEFAULT_WEBDRIVER_ERROR;
    }
}

