/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.util.error.ErrorAnalysisUtils;
import dev.pumpo5.core.util.error.ErrorType;
import dev.pumpo5.core.webdriver.PumpoClientConfig;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.core.webdriver.WebDriverClientExtension;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.ConnectionFailedException;

public abstract class AbstractRemoteDriverAgent
implements RemoteDriverAgent {
    protected Logger logger;
    protected Driver driver;

    AbstractRemoteDriverAgent(Logger logger) {
        this.logger = logger;
    }

    public AbstractRemoteDriverAgent(Logger logger, Config config, Map<String, Object> capabilities, String farmUrl) {
        this(logger);
        System.setProperty("webdriver.http.factory", "pn5-http-client");
        this.driver = this.initDriver(capabilities, config, farmUrl);
    }

    protected Driver initDriver(Map<String, Object> capabilities, Config config, String farmUrl) {
        try {
            PumpoClientConfig pn5Config;
            ClientConfig clientConfig = ClientConfig.defaultConfig().baseUrl(URI.create(farmUrl).toURL());
            clientConfig = this.withTimeouts(capabilities, clientConfig);
            boolean ignoreTls = config.getBoolean("pn5.webdriver.tls.ignore");
            if (ignoreTls) {
                this.logger.log(LogLevel.INFO, "Ignoring test farm certificate issues (global setting)", new Object[0]);
                pn5Config = PumpoClientConfig.from(clientConfig);
                pn5Config.setIgnoreTls(true);
                clientConfig = pn5Config;
            } else if (capabilities.containsKey("pn5:tls:ignore")) {
                this.logger.log(LogLevel.INFO, "Ignoring test farm certificate issues (global setting)", new Object[0]);
                pn5Config = PumpoClientConfig.from(clientConfig);
                pn5Config.setIgnoreTls(Boolean.parseBoolean(capabilities.get("pn5:tls:ignore").toString()));
                clientConfig = pn5Config;
            }
            HttpCommandExecutor executor = new HttpCommandExecutor(this.getAdditionalCommands(), clientConfig, HttpCommandExecutor.getDefaultClientFactory());
            return new Driver((CommandExecutor)executor, new MutableCapabilities(capabilities));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void logCapabilities(Map<String, Object> capabilities) {
        if (Boolean.TRUE.equals(capabilities.getOrDefault("pn5.capabilities.dump", Boolean.TRUE))) {
            this.logger.log(LogLevel.INFO, "Initializing remote driver with following capabilities...", new Object[0]);
            for (Map.Entry<String, Object> capability : capabilities.entrySet()) {
                if (capability.getKey().contains("hidden:")) {
                    this.logger.log(LogLevel.INFO, "Capability: {}, value: {}", capability.getKey(), "**********");
                    continue;
                }
                this.logger.log(LogLevel.INFO, "Capability: {}, value: {}", capability.getKey(), capability.getValue());
            }
        }
    }

    protected ClientConfig withTimeouts(Map<String, Object> capabilities, ClientConfig clientConfig) {
        Duration timeout;
        String timeoutString = WebDriverClientExtension.getCapabilityUnder(capabilities, "selenoid:options", "sessionTimeout");
        try {
            timeout = Duration.parse(("PT" + timeoutString).toUpperCase(Locale.ROOT));
        }
        catch (DateTimeParseException fail) {
            this.logger.log(LogLevel.WARN, "Cannot parse {} as Duration. Default read timeout will be used", timeoutString);
            timeout = Duration.ofSeconds(70L);
        }
        return clientConfig.connectionTimeout(timeout).readTimeout(timeout);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    protected abstract Map<String, CommandInfo> getAdditionalCommands();

    protected class Driver
    extends RemoteWebDriver {
        private static final int MAX_ATTEMPTS = 3;

        public Driver(CommandExecutor executor, MutableCapabilities capabilities) {
            super(executor, (Capabilities)capabilities);
        }

        public synchronized Response execute(String name, Map<String, ?> params) {
            for (int attempt = 1; attempt <= 3; ++attempt) {
                TestUtils.threadSleep(0x28 ^ attempt);
                AbstractRemoteDriverAgent.this.logger.log(LogLevel.DEBUG, "Executing command {} with params {}, attempt {}", name, params, attempt);
                try {
                    return super.execute(name, params);
                }
                catch (WebDriverException e) {
                    if (!ErrorAnalysisUtils.analyseAndLogWebDriverError(e, AbstractRemoteDriverAgent.this.logger).equals((Object)ErrorType.DEFAULT_WEBDRIVER_ERROR)) {
                        throw this.removeHiddenCapabilitiesFromLog(e);
                    }
                    if (((Object)((Object)e)).getClass().equals(WebDriverException.class) || ((Object)((Object)e)).getClass().equals(ConnectionFailedException.class) || ((Object)((Object)e)).getClass().equals(UnreachableBrowserException.class) || ((Object)((Object)e)).getClass().equals(SessionNotCreatedException.class)) {
                        AbstractRemoteDriverAgent.this.logger.log(LogLevel.ERROR, "Command execution failed, attempt {}/{}: {}", attempt, 3, this.removeHiddenCapabilitiesFromLog(e).getMessage());
                        if (attempt != 3) continue;
                        throw this.removeHiddenCapabilitiesFromLog(e);
                    }
                    throw this.removeHiddenCapabilitiesFromLog(e);
                }
            }
            return null;
        }

        private WebDriverException removeHiddenCapabilitiesFromLog(WebDriverException e) {
            String capabilities = StringUtils.substringBetween((String)e.getAdditionalInformation(), (String)"Capabilities ", (String)"Session ID");
            if (capabilities != null) {
                String[] arrayOfCapabilities = capabilities.split(",");
                String newCapabilitiesString = Stream.of(arrayOfCapabilities).map(cap -> {
                    if (cap.contains("hidden:")) {
                        String[] cap_split = cap.trim().split(" ");
                        return " " + cap_split[0] + " **********";
                    }
                    return cap;
                }).collect(Collectors.joining(",")) + "\n";
                e.addInfo("Capabilities", newCapabilitiesString);
                return e;
            }
            return e;
        }
    }

    protected static class ClientProxyInvocationHandler<CLIENT extends RemoteDriverAgent>
    implements InvocationHandler {
        private final CLIENT client;

        public ClientProxyInvocationHandler(CLIENT client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!method.getDeclaringClass().isAssignableFrom(this.client.getClass())) {
                throw new IllegalStateException(String.format("Calling methods outside %s are not supported by the proxy", this.client.getClass().getSimpleName()));
            }
            return method.invoke(this.client, args);
        }
    }
}

