/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.ReflectionUtils;
import dev.pumpo5.core.util.error.ErrorAnalysisUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ApplicationProxyInvocationHandler<APPLICATION>
implements InvocationHandler {
    private final APPLICATION delegate;
    private final Class<?> original;

    public ApplicationProxyInvocationHandler(Class<?> original, APPLICATION delegate) {
        this.delegate = delegate;
        this.original = original;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass().equals(this.original) && method.isDefault()) {
                return ReflectionUtils.invokeProxyDefaultMethod(proxy, method, args);
            }
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            ErrorAnalysisUtils.analyseAndLogWebDriverError(e, ((CoreAccessor)this.delegate).getLogger());
            throw ExceptionUtils.getRootCause((Throwable)e);
        }
    }

    public APPLICATION getDelegate() {
        return this.delegate;
    }
}

