/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.EndpointDsl;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.Store;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.reporting.Reporter;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class ApplicationSupport<APP>
implements EndpointDsl,
CoreAccessor,
SessionManager<APP> {
    protected final CoreAccessor core;
    protected String driverUrl;
    protected Map<String, Object> capabilities;
    protected boolean manualSessionManagement;
    private boolean sessionManagerUnlocked = false;
    private boolean invokedByBeforeAllMethodInTests = false;

    public ApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        this.core = core;
        this.driverUrl = driverUrl;
        this.capabilities = capabilities;
        this.resolveSessionManagementMode(capabilities);
        if (!this.manualSessionManagement) {
            this.unlockSessionManagement();
            this.getLogger().log(LogLevel.INFO, "Session management AUTO, starting session for {}", this.getEndpointDslName());
            this.startSession();
        } else {
            this.getLogger().log(LogLevel.INFO, "Session management MANUAL for {}", this.getEndpointDslName());
        }
    }

    private void resolveSessionManagementMode(Map<String, Object> capabilities) {
        if (capabilities.containsKey("pn5:manualSession") && ((Boolean)capabilities.get("pn5:manualSession")).booleanValue()) {
            this.manualSessionManagement = true;
            this.sessionManagerUnlocked = true;
        }
    }

    @Override
    public Store getLocalStore() {
        return this.core.getLocalStore();
    }

    @Override
    public Store getGlobalStore() {
        return this.core.getGlobalStore();
    }

    @Override
    public Config getConfig() {
        return this.core.getConfig();
    }

    @Override
    public Reporter getReporter() {
        return this.core.getReporter();
    }

    @Override
    public Logger getLogger() {
        return this.core.getLogger();
    }

    public abstract RemoteDriverAgent newAgent();

    public abstract RemoteDriverAgent agent();

    void unlockSessionManagement() {
        this.sessionManagerUnlocked = true;
    }

    @Override
    public APP startSession() {
        this.invokedByBeforeAllMethodInTests = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(method -> method.getMethodName().contains("invokeBeforeAllMethods"));
        if (this.sessionManagerUnlocked) {
            if (this.manualSessionManagement) {
                this.getLogger().log(LogLevel.INFO, "Manually starting session for {}", this.getEndpointDslName());
            }
            this.startSessionImplementation();
            this.getLogger().log(LogLevel.INFO, "Session {} created for {}", ((RemoteWebDriver)this.agent().getDriver()).getSessionId(), this.getEndpointDslName());
            if (!this.manualSessionManagement) {
                this.sessionManagerUnlocked = false;
            }
        } else {
            this.throwIllegalAccessToSessionManagement();
        }
        return (APP)this;
    }

    private void throwIllegalAccessToSessionManagement() {
        throw new RuntimeException(new IllegalAccessException("This method is forbidden because session management has been left as automatic. If you want to manage sessions manually, add to the given Application the capability pn5:manualSession to true."));
    }

    protected abstract void startSessionImplementation();

    @Override
    public APP closeSession() {
        boolean invokedByAfterAllMethodInTests;
        if (this.invokedByBeforeAllMethodInTests && !(invokedByAfterAllMethodInTests = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(method -> method.getMethodName().contains("invokeAfterAllMethods")))) {
            return (APP)this;
        }
        if (this.agent() != null) {
            if (this.sessionManagerUnlocked) {
                if (!this.isSessionIdNull()) {
                    this.getLogger().log(LogLevel.INFO, "Closing session for {}", this.getEndpointDslName());
                }
                this.closeSessionImplementation();
                if (!this.manualSessionManagement) {
                    this.sessionManagerUnlocked = false;
                }
            } else {
                this.throwIllegalAccessToSessionManagement();
            }
        }
        return (APP)this;
    }

    protected abstract void closeSessionImplementation();

    protected void checkSessionStarted() {
        if (this.agent() == null) {
            throw new IllegalStateException("Session is not started");
        }
    }

    protected void attemptClosingSession(RemoteDriverAgent agent) {
        try {
            agent.getDriver().quit();
        }
        catch (Exception e) {
            this.core.getLogger().log(LogLevel.WARN, "Exception thrown when attempting to close the previous session: {}", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void closeSessionAfterTest() {
        if (!this.isBooleanCapabilityOn("pn5:keepSession")) {
            this.unlockSessionManagement();
            this.closeSession();
        }
    }

    private boolean isBooleanCapabilityOn(String feature) {
        return this.capabilities.containsKey(feature) && Boolean.parseBoolean(this.capabilities.get(feature).toString());
    }

    private String getEndpointDslName() {
        return Arrays.stream(this.getClass().getInterfaces()).filter(aClass -> Arrays.asList(aClass.getInterfaces()).contains(EndpointDsl.class)).findFirst().map(Class::getSimpleName).orElse(this.getClass().getSimpleName());
    }

    private boolean isSessionIdNull() {
        return ((RemoteWebDriver)this.agent().getDriver()).getSessionId() == null;
    }
}

