/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.core.Lookup;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public interface InteractiveRemoteDriverAgent
extends RemoteDriverAgent {
    default public Function<String, By> translateLookup(Lookup lookup) {
        throw new UnsupportedOperationException("This agent does not support translateLookup(Lookup lookup) method");
    }

    public String getText(String var1, Lookup var2, int var3);

    public String getUrl();

    public String getAttribute(String var1, Lookup var2, String var3, int var4);

    public void wait(String var1, Lookup var2, int var3);

    public void setValue(String var1, Lookup var2, String var3, int var4, boolean var5);

    public Dimension getSize(String var1, Lookup var2);

    default public WebElement find(SearchContext context, String selector, Lookup type, int timeout) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot lookup element: SearchContext is null");
        }
        long startTime = System.currentTimeMillis();
        long deadline = startTime + (long)timeout * 1000L;
        while (true) {
            long iterationStartTime = System.currentTimeMillis();
            try {
                return context.findElement(this.translateLookup(type).apply(selector));
            }
            catch (NoSuchElementException | NoSuchWindowException exception) {
                if (iterationStartTime >= deadline) {
                    throw exception;
                }
                long timeToSleep = iterationStartTime + 1000L - System.currentTimeMillis();
                if (timeToSleep <= 0L) continue;
                TestUtils.threadSleep(timeToSleep);
                continue;
            }
            break;
        }
    }

    default public WebElement find(String selector, Lookup type, int timeout) {
        return this.find((SearchContext)this.getDriver(), selector, type, timeout);
    }

    default public WebElement find(String selector, Lookup type) {
        return this.find((SearchContext)this.getDriver(), selector, type, 10);
    }

    default public WebElement find(String selector) {
        return this.find((SearchContext)this.getDriver(), selector, Lookup.DEFAULT, 10);
    }

    default public File clickAndDownload(String selector, Lookup type, int timeout) {
        return this.clickAndDownload(selector, type, timeout);
    }

    default public void click(String selector, Lookup type, int timeout, boolean tryCoordinates) {
        this.click(selector, type, timeout, false);
    }

    default public void click(String selector, Lookup type, int timeout) {
        this.click(selector, type, timeout, false);
    }

    default public void click(String selector, Lookup type) {
        this.click(selector, type, 10, false);
    }

    default public void click(String selector) {
        this.click(selector, Lookup.DEFAULT, 10, false);
    }

    public void doubleClick(String var1, Lookup var2, int var3, boolean var4);

    public void scrollIntoView(String var1, Lookup var2, int var3);

    public void sendKeys(String var1, Lookup var2, String var3, int var4);

    default public void sendKeys(String selector, Lookup type, String keysToSend) {
        this.sendKeys(selector, type, keysToSend, 10);
    }

    default public void sendKeys(String selector, String keysToSend) {
        this.sendKeys(selector, Lookup.DEFAULT, keysToSend, 10);
    }

    public Optional<WebElement> tryToFind(SearchContext var1, String var2, Lookup var3, Duration var4);

    default public Optional<WebElement> tryToFind(String selector, Lookup type, Duration timeout) {
        return this.tryToFind((SearchContext)this.getDriver(), selector, type, timeout);
    }

    default public Optional<WebElement> tryToFind(String selector, Lookup type, int timeoutInSeconds) {
        return this.tryToFind((SearchContext)this.getDriver(), selector, type, Duration.ofSeconds(timeoutInSeconds));
    }

    default public Optional<WebElement> tryToFind(String selector, Lookup type) {
        return this.tryToFind((SearchContext)this.getDriver(), selector, type, Duration.ofSeconds(10L));
    }

    default public Optional<WebElement> tryToFind(String selector) {
        return this.tryToFind((SearchContext)this.getDriver(), selector, Lookup.DEFAULT, Duration.ofSeconds(10L));
    }

    default public boolean isPresent(String selector, Lookup type) {
        try {
            this.getDriver().findElement(this.translateLookup(type).apply(selector));
            this.wait(selector, type, 1);
            return true;
        }
        catch (NoSuchElementException | NoSuchWindowException ex) {
            return false;
        }
    }

    default public boolean isPresent(String selector) {
        return this.isPresent(selector, Lookup.DEFAULT);
    }

    default public boolean notPresent(String selector, Lookup type) {
        return !this.isPresent(selector, type);
    }

    default public boolean gone(String selector, Lookup type) {
        return this.notPresent(selector, type);
    }

    default public void wait(Duration timeout, Predicate<? super InteractiveRemoteDriverAgent> until) {
        FluentWait wait = new FluentWait((Object)this.getDriver()).withTimeout(timeout).pollingEvery(Duration.ofSeconds(1L)).ignoring(Exception.class);
        wait.until(webDriver -> until.test(this));
    }

    default public byte[] takeScreenshot() {
        return this.takeScreenshot((TakesScreenshot)this.getDriver());
    }

    default public byte[] takeScreenshot(TakesScreenshot takesScreenshot) {
        return (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
    }

    default public byte[] takeScreenshot(String selector, Lookup type) {
        throw new UnsupportedOperationException("This agent does not support takeScreenshot(String selector, Lookup type) method");
    }
}

