/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.PumpoException;
import dev.pumpo5.actions.AssertAttributeValue;
import dev.pumpo5.actions.AssertElementAbsent;
import dev.pumpo5.actions.AssertElementContent;
import dev.pumpo5.actions.AssertElementPresent;
import dev.pumpo5.actions.AssertUrl;
import dev.pumpo5.actions.ExtendedAction;
import dev.pumpo5.actions.GetAttributeValue;
import dev.pumpo5.actions.GetElementContent;
import dev.pumpo5.actions.SendKeys;
import dev.pumpo5.actions.SetValue;
import dev.pumpo5.actions.StoreAttributeValue;
import dev.pumpo5.actions.StoreElementContent;
import dev.pumpo5.actions.Wait;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.ReflectionUtils;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.webdriver.InteractiveRemoteDriverAgent;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.logging.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javassist.util.proxy.MethodHandler;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(PumpoProxy.class);
    protected InteractiveRemoteDriverAgent agent;
    protected CoreAccessor core;
    protected MethodHandler handler = (self, thisMethod, proceed, args) -> {
        if (CoreAccessor.class.equals(thisMethod.getDeclaringClass())) {
            return thisMethod.invoke((Object)this.core, args);
        }
        this.enterInvocation();
        try {
            Object nextPageObject = proceed.invoke(self, args);
            if (nextPageObject == null) {
                Object var6_7 = null;
                return var6_7;
            }
            if (nextPageObject == self) {
                Object object = self;
                return object;
            }
            if (javassist.util.proxy.ProxyFactory.isProxyClass(nextPageObject.getClass())) {
                Object object = nextPageObject;
                return object;
            }
            Object object = this.prepareObjectProxy(nextPageObject);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            this.exitInvocation();
        }
    };

    public ProxyFactory(InteractiveRemoteDriverAgent agent, CoreAccessor core) {
        this.agent = agent;
        this.core = core;
    }

    public void enterInvocation() {
    }

    public void exitInvocation() {
    }

    protected Object handleReturnType(Optional<Object> maybeResult, CoreAccessor core, Object proxy, Method method, Object[] args) {
        return Stream.of(() -> maybeResult.filter(o -> !this.isPageObjectCandidate(method.getReturnType())), () -> this.doGetElementContent(method, args), () -> this.doGetAttributeValue(method, args), () -> Optional.of(method.getReturnType()).filter(t -> t.isInstance(proxy)).map(t -> proxy), () -> Optional.of(method.getReturnType()).filter(this::isPageObjectCandidate).map(t -> this.prepareProxy((Class)t, false, core))).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalStateException("Failed to instantiate return value"));
    }

    protected boolean isPageObjectCandidate(Class<?> returnType) {
        return returnType.isInterface() && !returnType.getPackage().getName().startsWith("java.");
    }

    public <PAGE_OBJECT> PAGE_OBJECT prepareProxy(Class<PAGE_OBJECT> page, boolean navigate, CoreAccessor core) {
        this.processPageObjectAnnotations(page, navigate, core);
        return (PAGE_OBJECT)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{page}, (InvocationHandler)this.getInvocationHandler());
    }

    public <PAGE_OBJECT> PAGE_OBJECT prepareClassProxy(Class<PAGE_OBJECT> pageObjectClass) {
        if (Modifier.isFinal(pageObjectClass.getModifiers())) {
            throw new IllegalArgumentException(String.format("We cannot start with Page Object of class %s because that class is final, cannot make proxy for it", pageObjectClass.getSimpleName()));
        }
        return (PAGE_OBJECT)this.prepareProxy(pageObjectClass);
    }

    public <PAGE> PAGE prepareObjectProxy(PAGE page) {
        if (Modifier.isFinal(page.getClass().getModifiers())) {
            return page;
        }
        return this.prepareProxy(page.getClass());
    }

    protected <PAGE> PAGE prepareProxy(Class<?> pageClass) {
        try {
            javassist.util.proxy.ProxyFactory factory = new javassist.util.proxy.ProxyFactory();
            factory.setSuperclass(pageClass);
            return (PAGE)factory.create(new Class[0], new Object[0], this.handler);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processPageObjectAnnotations(Class<?> pageObject, boolean navigate, CoreAccessor core) {
        List interfaces = ClassUtils.getAllInterfaces(pageObject);
        interfaces.add(pageObject);
        interfaces.forEach(this::doWait);
        interfaces.forEach(this::doAssertUrl);
    }

    protected PumpoProxy getInvocationHandler() {
        return new PumpoProxy(this, this.core);
    }

    protected void doWait(AnnotatedElement type) {
        this.doWait(type, null);
    }

    protected void doWait(AnnotatedElement methodOrType, Object[] args) {
        Arrays.stream((Wait[])methodOrType.getAnnotationsByType(Wait.class)).forEach(annotation -> {
            String selector = annotation.value();
            if (StringUtils.isEmpty((CharSequence)selector)) {
                LOG.debug("{} > @Wait explicitly for {}s", (Object)this.getAnnotatedElementShortName(methodOrType), (Object)annotation.timeout());
                this.explicitWait(annotation.timeout());
            } else {
                String finalSelector = this.processSelector(selector, args, 0, (Annotation)annotation);
                LOG.debug("{} > @Wait for {} by {} with timeout {}s", new Object[]{this.getAnnotatedElementShortName(methodOrType), finalSelector, annotation.by(), annotation.timeout()});
                this.agent.wait(finalSelector, annotation.by(), annotation.timeout());
            }
        });
    }

    private void explicitWait(int timeoutSeconds) {
        try {
            TimeUnit.SECONDS.sleep(timeoutSeconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void assertElementPresent(Method method, Object[] args) {
        Arrays.stream((AssertElementPresent[])method.getAnnotationsByType(AssertElementPresent.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @AssertElementPresent for {} by {} with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            try {
                this.agent.wait(finalSelector, annotation.by(), annotation.timeout());
            }
            catch (NoSuchElementException | NoSuchWindowException e) {
                throw new AssertionError("Element not present", e);
            }
        });
    }

    protected void assertElementAbsent(Method method, Object[] args) {
        Arrays.stream((AssertElementAbsent[])method.getAnnotationsByType(AssertElementAbsent.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @AssertElementAbsent for {} by {} with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            Optional<WebElement> maybeElement = this.agent.tryToFind(finalSelector, annotation.by(), annotation.timeout());
            if (maybeElement.isPresent()) {
                throw new AssertionError((Object)"Element is present, but was expected to be absent");
            }
        });
    }

    protected void assertElementContent(Method method, Object[] args) {
        AssertElementContent annotation = method.getAnnotation(AssertElementContent.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@AssertElementContent requires at least one parameter");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 1, annotation);
            Object expected = args[args.length - 1];
            LOG.debug("{} > @AssertElementContent for {} by {} with timeout {}s equals to {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), expected});
            String actual = this.agent.getText(finalSelector, annotation.by(), annotation.timeout());
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected Optional<Object> doGetElementContent(Method method, Object[] args) {
        GetElementContent annotation = method.getAnnotation(GetElementContent.class);
        if (annotation != null) {
            if (StringUtils.isEmpty((CharSequence)annotation.value())) {
                throw new IllegalArgumentException("Empty value is not allowed for annotation @GetElementContent");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @GetElementContent for {} by {} with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            String text = this.agent.getText(finalSelector, annotation.by(), annotation.timeout());
            return Optional.ofNullable(text);
        }
        return Optional.empty();
    }

    protected void doStoreElementContent(Method method, Object[] args) {
        StoreElementContent annotation = method.getAnnotation(StoreElementContent.class);
        if (annotation != null) {
            if (StringUtils.isEmpty((CharSequence)annotation.key())) {
                throw new IllegalArgumentException("Empty key is not allowed for annotation @StoreElementContent");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @StoreElementContent for {} by {} with timeout {}s to be stored to key {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), annotation.key()});
            String text = this.agent.getText(finalSelector, annotation.by(), annotation.timeout());
            if (annotation.globalStore()) {
                this.core.getGlobalStore().store(annotation.key(), text);
            } else {
                this.core.getLocalStore().store(annotation.key(), text);
            }
        }
    }

    protected void assertAttributeValue(Method method, Object[] args) {
        AssertAttributeValue annotation = method.getAnnotation(AssertAttributeValue.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@AssertAttributeValue requires at least one parameter");
            }
            if (StringUtils.isEmpty((CharSequence)annotation.attributeName())) {
                throw new IllegalArgumentException("Empty attributeName is not allowed for annotation @AssertAttributeValue");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 1, annotation);
            Object expected = args[args.length - 1];
            LOG.debug("{} > @AssertAttributeValue for {} by {} with timeout {}s name {} to be equal {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), annotation.attributeName(), expected});
            String actual = this.agent.getAttribute(finalSelector, annotation.by(), annotation.attributeName(), annotation.timeout());
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected void doStoreAttributeValue(Method method, Object[] args) {
        StoreAttributeValue annotation = method.getAnnotation(StoreAttributeValue.class);
        if (annotation != null) {
            if (StringUtils.isEmpty((CharSequence)annotation.key())) {
                throw new IllegalArgumentException("Empty key is not allowed for annotation @StoreAttributeValue");
            }
            if (StringUtils.isEmpty((CharSequence)annotation.attributeName())) {
                throw new IllegalArgumentException("Empty attributeName is not allowed for annotation @StoreAttributeValue");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @StoreAttributeValue for {} by {} with timeout {}s name {} to key {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), annotation.attributeName(), annotation.key()});
            String text = this.agent.getAttribute(finalSelector, annotation.by(), annotation.attributeName(), annotation.timeout());
            if (annotation.globalStore()) {
                this.core.getGlobalStore().store(annotation.key(), text);
            } else {
                this.core.getLocalStore().store(annotation.key(), text);
            }
        }
    }

    protected Optional<Object> doGetAttributeValue(Method method, Object[] args) {
        GetAttributeValue annotation = method.getAnnotation(GetAttributeValue.class);
        if (annotation != null) {
            if (StringUtils.isEmpty((CharSequence)annotation.value())) {
                throw new IllegalArgumentException("Empty value is not allowed for annotation @GetAttributeValue");
            }
            if (StringUtils.isEmpty((CharSequence)annotation.attributeName())) {
                throw new IllegalArgumentException("Empty attributeName is not allowed for annotation @GetAttributeValue");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @GetAttributeValue for {} by {} with timeout {}s name {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), annotation.attributeName()});
            String text = this.agent.getAttribute(finalSelector, annotation.by(), annotation.attributeName(), annotation.timeout());
            return Optional.ofNullable(text);
        }
        return Optional.empty();
    }

    protected void doSendKeys(Method method, Object[] args) {
        SendKeys annotation = method.getAnnotation(SendKeys.class);
        if (annotation != null) {
            String keysToSend;
            int ignoreLastArgsCount = 1;
            if (!annotation.keys().isEmpty()) {
                keysToSend = annotation.keys();
                ignoreLastArgsCount = 0;
            } else if (args != null && args.length > 0 && String.class.isAssignableFrom(args[args.length - 1].getClass())) {
                keysToSend = (String)args[args.length - 1];
            } else {
                throw new IllegalArgumentException("@SendKeys requires keys to be sent either as keys attribute of the annotation or as last argument of the method");
            }
            String selector = this.processSelector(annotation.value(), args, ignoreLastArgsCount, annotation);
            LOG.debug("{} > @SendKeys for {} by {} for option with timeout {}s with value to send {}", new Object[]{this.getAnnotatedElementShortName(method), selector, annotation.by(), annotation.timeout(), URLEncoder.encode(keysToSend, StandardCharsets.UTF_8)});
            this.agent.sendKeys(selector, annotation.by(), keysToSend, annotation.timeout());
        }
    }

    protected void doLog(Method method, Object[] args) {
        Arrays.stream((Log[])method.getAnnotationsByType(Log.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @Log for {} by {} with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            String text = this.agent.getText(finalSelector, annotation.by(), annotation.timeout());
            this.core.getLogger().log(annotation.template(), text);
        });
    }

    protected void doSetValue(Method method, Object[] args) {
        SetValue annotation = method.getAnnotation(SetValue.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@SetValue requires at least one parameter");
            }
            String finalSelector = this.processSelector(annotation.value(), args, 1, annotation);
            String value = String.valueOf(args[args.length - 1]);
            LOG.debug("{} > @SetValue for {} by {} with timeout {}s to value {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout(), value});
            this.agent.setValue(finalSelector, annotation.by(), value, annotation.timeout(), annotation.byTyping());
        }
    }

    protected void doAssertUrl(AnnotatedElement type) {
        this.doAssertUrl(type, null);
    }

    public void doAssertUrl(AnnotatedElement methodOrType, Object[] args) {
        AssertUrl annotation = methodOrType.getAnnotation(AssertUrl.class);
        if (annotation != null) {
            Object expected;
            if (!annotation.value().isEmpty()) {
                expected = annotation.value();
            } else if (args != null && args.length > 0) {
                expected = args[args.length - 1];
            } else {
                throw new IllegalArgumentException("@AssertUrl requires value to be sent either as value attribute of the annotation or as last argument of the method");
            }
            LOG.debug("{} > @AssertUrl equals {}", (Object)this.getAnnotatedElementShortName(methodOrType), expected);
            String actual = this.agent.getUrl();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)"The URL value doesn\u00b4t equal to the expected URL");
        }
    }

    public Optional<Object> doExtendedAction(Object proxy, Method method, Object[] args) {
        return Optional.of(method).map(method1 -> {
            if (!method.isDefault()) {
                throw new IllegalStateException(String.format("Method '%s#%s' is annotated with @ExtendedAction yet is not a default interface method", method1.getDeclaringClass().getSimpleName(), method1.getName()));
            }
            return method1;
        }).map(method1 -> {
            LOG.debug("{} > @ExtendedAction with arguments {}", (Object)this.getAnnotatedElementShortName(method), (Object)args);
            ExtendedAction annotation = method1.getAnnotation(ExtendedAction.class);
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            while (true) {
                try {
                    return this.invokeDefaultMethod(proxy, (Method)method1, args);
                }
                catch (PumpoException e) {
                    LOG.debug("{} > @ExtendedAction failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), e.getClass().getSimpleName(), retries, pause});
                    PumpoException lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @ExtendedAction waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @ExtendedAction now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries != 0) continue;
                    LOG.warn("{} > @ExtendedAction ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                    lastException.addSuppressed(new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                    throw lastException;
                }
                break;
            }
        });
    }

    protected <TYPE> TYPE invokeDefaultMethod(Object proxy, Method method, Object[] args) {
        try {
            return ReflectionUtils.invokeProxyDefaultMethod(proxy, method, args);
        }
        catch (Throwable e) {
            if (RuntimeException.class.isAssignableFrom(e.getClass())) {
                throw (RuntimeException)e;
            }
            throw new PumpoException(String.format("\n\nError invoking method '%s#%s'. \n\nError message: %s", method.getDeclaringClass().getSimpleName(), method.getName(), e.getMessage()), e);
        }
    }

    protected String processSelector(String selector, Object[] args, int ignoreLastArgsCount, Annotation annotation) {
        if (StringUtils.isEmpty((CharSequence)selector)) {
            throw new IllegalArgumentException(String.format("Empty selector is not allowed for annotation @%s", annotation.annotationType().getSimpleName()));
        }
        if (args == null) {
            return selector;
        }
        Object[] formatArgs = ignoreLastArgsCount > 0 ? Arrays.copyOf(args, args.length - ignoreLastArgsCount) : args;
        return String.format(selector, formatArgs);
    }

    protected String getAnnotatedElementShortName(AnnotatedElement methodOrType) {
        if (Method.class.isAssignableFrom(methodOrType.getClass())) {
            Method method = (Method)methodOrType;
            return method.getDeclaringClass().getSimpleName() + "::" + method.getName();
        }
        return ((Class)methodOrType).getSimpleName();
    }
}

