/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import com.google.auto.service.AutoService;
import dev.pumpo5.core.webdriver.PumpoClientConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.jdk.JdkHttpClient;

public class PumpoJdkHttpClient
implements HttpClient {
    private JdkHttpClient delegate;
    private static final TrustManager EMPTY_TRUST_MANAGER = new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }
    };

    public PumpoJdkHttpClient(ClientConfig config) {
        try {
            Constructor declaredConstructor = JdkHttpClient.class.getDeclaredConstructor(ClientConfig.class);
            declaredConstructor.setAccessible(true);
            this.delegate = (JdkHttpClient)declaredConstructor.newInstance(config);
            Field executorServiceField = JdkHttpClient.class.getDeclaredField("executorService");
            executorServiceField.setAccessible(true);
            ExecutorService executorService = (ExecutorService)executorServiceField.get(this.delegate);
            java.net.http.HttpClient ourClient = this.buildClient(config, executorService);
            Field clientField = JdkHttpClient.class.getDeclaredField("client");
            clientField.setAccessible(true);
            clientField.set(this.delegate, ourClient);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    java.net.http.HttpClient buildClient(ClientConfig config, ExecutorService executorService) throws NoSuchAlgorithmException, KeyManagementException {
        PumpoClientConfig pumpoClientConfig;
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().connectTimeout(config.connectionTimeout()).followRedirects(HttpClient.Redirect.NEVER).executor(executorService);
        if (config instanceof PumpoClientConfig && (pumpoClientConfig = (PumpoClientConfig)config).isIgnoreTls()) {
            SSLContext tlsContext = SSLContext.getInstance("TLS");
            tlsContext.init(null, new TrustManager[]{EMPTY_TRUST_MANAGER}, new SecureRandom());
            builder.sslContext(tlsContext);
        }
        Credentials credentials = config.credentials();
        String info = config.baseUri().getUserInfo();
        if (info != null && !info.trim().isEmpty()) {
            String[] parts = info.split(":", 2);
            final String username = parts[0];
            final String password = parts.length > 1 ? parts[1] : null;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password: " + credentials);
            }
            final UsernameAndPassword uap = (UsernameAndPassword)credentials;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(uap.username(), uap.password().toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        }
        final Proxy proxy = config.proxy();
        if (proxy != null) {
            ProxySelector proxySelector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    if (proxy == null) {
                        return List.of();
                    }
                    if (uri.getScheme().toLowerCase().startsWith("http")) {
                        return List.of(proxy);
                    }
                    return List.of();
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            };
            builder = builder.proxy(proxySelector);
        }
        return builder.build();
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        return this.delegate.openSocket(request, listener);
    }

    public void close() {
        this.delegate.close();
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.delegate.execute(req);
    }

    public HttpHandler with(Filter filter) {
        return this.delegate.with(filter);
    }

    @HttpClientName(value="pn5-http-client")
    @AutoService(value={HttpClient.Factory.class})
    public static class Factory
    implements HttpClient.Factory {
        public HttpClient createClient(ClientConfig config) {
            Objects.requireNonNull(config, "Client config must be set");
            return new PumpoJdkHttpClient(config);
        }
    }
}

