/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.PumpoException;
import dev.pumpo5.actions.ExtendedAction;
import dev.pumpo5.config.ConfigKey;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.Reportable;
import dev.pumpo5.core.ReportableMixinInvocationHandler;
import dev.pumpo5.core.ReporterMixin;
import dev.pumpo5.core.util.error.ErrorAnalysisUtils;
import dev.pumpo5.core.webdriver.ProxyFactory;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openqa.selenium.WebDriverException;

public class PumpoProxy
implements InvocationHandler {
    private final ProxyFactory factory;
    private final CoreAccessor core;

    public PumpoProxy(ProxyFactory factory, CoreAccessor core) {
        this.factory = factory;
        this.core = core;
    }

    protected void resolveConfigParameters(Method method, Object[] args, CoreAccessor core) {
        Parameter[] parameters = method.getParameters();
        IntStream.range(0, parameters.length).forEach(i -> {
            Parameter parameter = parameters[i];
            ConfigKey annotation = parameter.getAnnotation(ConfigKey.class);
            if (annotation != null) {
                String configValue = core.getConfig().get(String.valueOf(args[i]));
                if (configValue == null) {
                    throw new IllegalArgumentException(String.format("Parameter of method %s#%s is defined as a config key, but commons.config key '%s' was not found. Is it spelled correctly in your config file?", method.getDeclaringClass().getName(), method.getName(), args[i]));
                }
                args[i] = configValue;
            }
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        this.factory.enterInvocation();
        this.resolveConfigParameters(method, args, this.core);
        try {
            Optional<Object> maybeResult = this.processDelegates(this.core, proxy, method, args);
            if (maybeResult.isPresent()) {
                Object object = maybeResult.get();
                return object;
            }
            Integer resultOption = this.processSwitchAnnotation(method, args);
            if (resultOption != null) {
                Integer n = resultOption;
                return n;
            }
            File file = this.processClickAndDownloadAnnotation(method, args);
            if (file != null) {
                File file2 = file;
                return file2;
            }
            this.processAnnotations(method, args);
            if (method.isAnnotationPresent(ExtendedAction.class)) {
                maybeResult = this.factory.doExtendedAction(proxy, method, args);
            } else if (method.isDefault()) {
                maybeResult = Optional.ofNullable(this.factory.invokeDefaultMethod(proxy, method, args));
            }
            if (method.getReturnType() == Void.TYPE) {
                Object var7_12 = null;
                return var7_12;
            }
            Object object = this.factory.handleReturnType(maybeResult, this.core, proxy, method, args);
            return object;
        }
        catch (WebDriverException e) {
            throw this.createPumpoException(method, e);
        }
        catch (AssertionError e) {
            ErrorAnalysisUtils.analyseAndLogWebDriverError((Throwable)((Object)e), this.core.getLogger());
            throw this.createPumpoException(method, (Throwable)((Object)e));
        }
        finally {
            this.factory.exitInvocation();
        }
    }

    protected File processClickAndDownloadAnnotation(Method method, Object[] args) {
        return null;
    }

    protected Integer processSwitchAnnotation(Method method, Object[] args) {
        return null;
    }

    protected void processAnnotations(Method method, Object[] args) {
        this.factory.doWait(method, args);
        this.factory.assertElementPresent(method, args);
        this.factory.assertElementAbsent(method, args);
        this.factory.assertElementContent(method, args);
        this.factory.doStoreElementContent(method, args);
        this.factory.assertAttributeValue(method, args);
        this.factory.doStoreAttributeValue(method, args);
        this.factory.doLog(method, args);
        this.factory.doAssertUrl(method, args);
        this.processFocusChangingAnnotations(method, args);
        this.processFocusRequiredAnnotations(method, args);
        this.processClipboardAnnotations(method, args);
    }

    protected void processFocusChangingAnnotations(Method method, Object[] args) {
    }

    protected void processFocusRequiredAnnotations(Method method, Object[] args) {
        this.factory.doSetValue(method, args);
        this.factory.doSendKeys(method, args);
    }

    protected void processClipboardAnnotations(Method method, Object[] args) {
    }

    protected Optional<Object> processDelegates(CoreAccessor core, Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (CoreAccessor.class.equals(method.getDeclaringClass())) {
            return Optional.ofNullable(method.invoke((Object)core, args));
        }
        if (Reportable.class.equals(method.getDeclaringClass())) {
            return Optional.of(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ReporterMixin.class}, (InvocationHandler)new ReportableMixinInvocationHandler(proxy, core.getReporter())));
        }
        return this.processAdditionalDelegates(core, proxy, method, args);
    }

    protected Optional<Object> processAdditionalDelegates(CoreAccessor core, Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return Optional.empty();
    }

    private PumpoException createPumpoException(Method method, Throwable e) throws PumpoException {
        return new PumpoException(String.format("%n%nError invoking method '%s#%s'. %n%nError message %s", method.getDeclaringClass().getSimpleName(), method.getName(), e.getMessage()), e);
    }
}

