/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.core.webdriver;

import dev.pumpo5.Utils;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.core.junit5.Core;
import dev.pumpo5.core.util.ExtensionUtils;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.Capability;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;

public abstract class WebDriverClientExtension<APPLICATION_OBJECT_TYPE>
implements ParameterResolver,
TestWatcher {
    private PumpoEvents logger = new PumpoEvents();
    public static final String TEST_PROXIES_KEY = "dev.pumpo5.testProxiesKeyForLocalStore";
    private final Class<APPLICATION_OBJECT_TYPE> clientType;

    protected WebDriverClientExtension(Class<APPLICATION_OBJECT_TYPE> applicationObjectType) {
        this.clientType = applicationObjectType;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Optional.of(parameterContext).map(ParameterContext::getParameter).map(Parameter::getType).filter(this.clientType::isAssignableFrom).isPresent();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Core core = Core.get(extensionContext);
        String driverUrl = ExtensionUtils.getDriverUrl(parameter, core.getConfig());
        core.getLogger().log(LogLevel.INFO, "Creating proxy for driver of type {} on url: {}", this.clientType.getSimpleName(), driverUrl);
        Map<String, Object> capabilities = this.getCapabilitiesFromAnnotations(core, parameter);
        ExtensionUtils.computeDefaults(capabilities);
        this.computeTestName(capabilities, core, extensionContext, parameterContext);
        return this.createAndRegisterProxy(parameter.getType(), driverUrl, capabilities, core);
    }

    private void computeTestName(Map<String, Object> capabilities, Core core, ExtensionContext extensionContext, ParameterContext parameterContext) {
        if (extensionContext.getTestMethod().isPresent()) {
            boolean enforceTesterIdentity = core.getConfig().getOrDefault((Object)"globalConfig.enforceTesterName", false);
            String testerIdentity = core.getConfig().get("tester.name");
            if (enforceTesterIdentity && testerIdentity == null) {
                String errorMessage = "Tester's identity needs to be configured in configuration files under the key tester.name";
                core.getLogger().log(LogLevel.ERROR, errorMessage, new Object[0]);
                throw new IllegalArgumentException(errorMessage);
            }
            DisplayName[] displayNameAnnotations = (DisplayName[])((Method)extensionContext.getTestMethod().get()).getAnnotationsByType(DisplayName.class);
            String methodDisplayName = displayNameAnnotations.length > 0 ? displayNameAnnotations[0].value() : ((Method)extensionContext.getTestMethod().get()).getName();
            StringBuilder testNameSB = new StringBuilder(64);
            if (testerIdentity != null) {
                testNameSB.append(testerIdentity).append(" - ");
            }
            testNameSB.append(Utils.currentTimeAsString(Utils.zoneIdFrom(core.getConfig().getOrDefault((Object)"timeZoneCity", "Prague")))).append(" - ").append(methodDisplayName).append(" >> ").append(parameterContext.getParameter().getType().getSimpleName()).append(" / ").append(parameterContext.getParameter().getName());
            String capabilityTestName = Objects.toString(capabilities.get("name"), null);
            if (capabilityTestName != null && !capabilityTestName.isBlank()) {
                testNameSB.append(" / ").append(capabilityTestName);
            }
            WebDriverClientExtension.ensureCapabilitiesGroup(capabilities, "selenoid:options").put("name", testNameSB);
        }
    }

    public static Map<String, Object> ensureCapabilitiesGroup(Map<String, Object> capabilities, String mapKey) {
        if (mapKey.equals("")) {
            return capabilities;
        }
        HashMap group = (HashMap)capabilities.get(mapKey);
        if (group == null) {
            group = new HashMap();
            capabilities.put(mapKey, group);
        }
        return group;
    }

    public static String getCapabilityUnder(Map<String, Object> capabilities, String groupKey, String key) {
        HashMap groupCapabilities = (HashMap)capabilities.get(groupKey);
        if (groupCapabilities != null) {
            return (String)groupCapabilities.get(key);
        }
        return null;
    }

    protected APPLICATION_OBJECT_TYPE createAndRegisterProxy(Class<? extends APPLICATION_OBJECT_TYPE> type, String driverUrl, Map<String, Object> capabilities, Core core) {
        APPLICATION_OBJECT_TYPE proxy = this.createProxy(type, driverUrl, capabilities, core);
        this.registerProxy(core, proxy);
        return proxy;
    }

    protected void registerProxy(Core core, APPLICATION_OBJECT_TYPE proxy) {
        core.getLocalStore().getOrCalculate(TEST_PROXIES_KEY, s -> new ArrayList()).add(proxy);
    }

    protected Map<String, Object> getCapabilitiesFromAnnotations(Core core, Parameter parameter) {
        Capability[] capabilitiesList = (Capability[])Stream.of((Capability[])parameter.getType().getAnnotationsByType(Capability.class), (Capability[])parameter.getAnnotationsByType(Capability.class)).flatMap(Stream::of).toArray(Capability[]::new);
        capabilitiesList = ExtensionUtils.analyzeCapabilities(capabilitiesList, core.getConfig());
        return ExtensionUtils.parseCapabilities(capabilitiesList, core.getConfig());
    }

    protected abstract APPLICATION_OBJECT_TYPE createProxy(Class<? extends APPLICATION_OBJECT_TYPE> var1, String var2, Map<String, Object> var3, CoreAccessor var4);

    public void testSuccessful(ExtensionContext context) {
        this.closeSessions(context);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.closeSessions(context);
    }

    protected void closeSessions(ExtensionContext context) {
        ArrayList registeredProxies = (ArrayList)context.getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent((Object)TEST_PROXIES_KEY, object -> new ArrayList());
        registeredProxies.forEach(proxy -> {
            ApplicationSupport applicationSupport = (ApplicationSupport)((ApplicationProxyInvocationHandler)Proxy.getInvocationHandler(proxy)).getDelegate();
            applicationSupport.closeSessionAfterTest();
            registeredProxies.remove(proxy);
        });
    }
}

