/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.data;

import dev.pumpo5.core.junit5.Core;
import dev.pumpo5.data.Data;
import dev.pumpo5.data.DataProvider;
import dev.pumpo5.data.DataProxyFactory;
import dev.pumpo5.data.FromCsv;
import dev.pumpo5.data.Generate;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class DataExtension
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Optional.of(parameterContext).filter(pc -> pc.findAnnotation(Data.class).isPresent()).map(ParameterContext::getParameter).filter(p -> p.getType().isInterface()).isPresent();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Stream.of(() -> Optional.of(parameterContext).filter(pc -> DataProvider.class.isAssignableFrom(pc.getParameter().getType())).flatMap(pc -> pc.findAnnotation(Generate.class)).map(g -> DataProxyFactory.generate(parameterContext.getParameter().getType(), Core.get(extensionContext), g.value())), () -> Optional.of(parameterContext).flatMap(pc -> pc.findAnnotation(FromCsv.class)).map(c -> DataProxyFactory.fromCsv(parameterContext.getParameter().getType(), Core.get(extensionContext), this.readFile(c.value()))), () -> Optional.of(parameterContext).map(c -> DataProxyFactory.create(parameterContext.getParameter().getType(), Core.get(extensionContext)))).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalStateException("Something went wrong"));
    }

    private String readFile(String path) throws ParameterResolutionException {
        try {
            URL resource = Optional.ofNullable(this.getClass().getClassLoader().getResource(path)).orElseThrow(() -> new IllegalArgumentException(String.format("Resource not found '%s'", path)));
            return Files.lines(Paths.get(resource.toURI())).collect(Collectors.joining("\n"));
        }
        catch (IOException | URISyntaxException e) {
            throw new ParameterResolutionException("That just did not work", (Throwable)e);
        }
    }
}

