/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.data;

import dev.pumpo5.PumpoException;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.ReflectionUtils;
import dev.pumpo5.data.CsvProvider;
import dev.pumpo5.data.DataProvider;
import dev.pumpo5.data.Generator;
import dev.pumpo5.data.Name;
import dev.pumpo5.data.Overridable;
import dev.pumpo5.data.Pattern;
import dev.pumpo5.data.StreamProvider;
import dev.pumpo5.data.Value;
import dev.pumpo5.data.ValueGenerator;
import dev.pumpo5.data.ValueType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class DataProxyFactory {
    private DataProxyFactory() {
    }

    public static <DATA, PROVIDER extends DataProvider<DATA, PROVIDER>> PROVIDER generate(Class<PROVIDER> clazz, CoreAccessor core, long limit) {
        Class<?> itemClazz = ReflectionUtils.getGenericType(clazz, DataProvider.class, 0);
        if (!itemClazz.isInterface()) {
            throw new IllegalArgumentException(String.format("Item class '%s' must be an interface.", itemClazz.getSimpleName()));
        }
        return DataProxyFactory.fromStream(clazz, itemClazz, core, Stream.generate(() -> DataProxyFactory.create(itemClazz, core)).limit(limit));
    }

    public static <DATA, PROVIDER extends DataProvider<DATA, PROVIDER>> PROVIDER fromCsv(Class<PROVIDER> clazz, CoreAccessor core, String csv) {
        Class<?> itemClazz = ReflectionUtils.getGenericType(clazz, DataProvider.class, 0);
        if (!itemClazz.isInterface()) {
            throw new IllegalArgumentException(String.format("Item class '%s' must be an interface.", itemClazz.getSimpleName()));
        }
        return DataProxyFactory.fromStream(clazz, itemClazz, core, CsvHandler.parse(csv, itemClazz).map(values -> DataProxyFactory.from(itemClazz, core, values)));
    }

    public static <DATA> DATA create(Class<DATA> clazz, CoreAccessor core) {
        return DataProxyFactory.from(clazz, core, new ConcurrentHashMap<String, Object>());
    }

    private static <DATA> DATA from(Class<DATA> clazz, CoreAccessor core, Map<String, Object> values) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Data provider class must be an interface.");
        }
        return (DATA)Proxy.newProxyInstance(DataProxyFactory.class.getClassLoader(), new Class[]{clazz}, new ItemProxyInvocationHandler<DATA>(clazz, core, values));
    }

    private static <DATA, PROVIDER extends DataProvider<DATA, PROVIDER>> PROVIDER fromStream(Class<PROVIDER> clazz, Class<DATA> itemClazz, CoreAccessor core, Stream<DATA> items) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Data provider class must be an interface extending DataProvider.");
        }
        return (PROVIDER)((DataProvider)Proxy.newProxyInstance(DataProxyFactory.class.getClassLoader(), new Class[]{clazz}, new DataProxyInvocationHandler<DATA>(itemClazz, core, items)));
    }

    private static <TYPE> TYPE invokeDefaultMethod(Object proxy, Method method, Object[] args) {
        try {
            return ReflectionUtils.invokeProxyDefaultMethod(proxy, method, args);
        }
        catch (Throwable e) {
            throw new PumpoException(String.format("\n\nError invoking method '%s#%s'. \n\nError message: %s", method.getDeclaringClass().getSimpleName(), method.getName(), e.getMessage()));
        }
    }

    private static Object computeValue(CoreAccessor core, Object proxy, Method method, Object[] args) {
        return Stream.of(() -> Optional.of(method).filter(Method::isDefault).map(m -> DataProxyFactory.invokeDefaultMethod(proxy, method, args)), () -> Optional.of(method).filter(m -> Date.class.isAssignableFrom(m.getReturnType())).map(m -> Optional.ofNullable(m.getAnnotation(Pattern.class)).map(p -> LocalDateTime.parse(DataProxyFactory.resolveValue(m.getAnnotation(Value.class), core), DateTimeFormatter.ofPattern(p.value()))).orElseGet(() -> LocalDateTime.parse(DataProxyFactory.resolveValue(m.getAnnotation(Value.class), core)))).map(ldt -> Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant())), () -> Optional.of(method).map(m -> m.getAnnotation(Value.class)).map(m -> DataProxyFactory.resolveValue(m, core)).map(v -> ConvertUtils.convert((String)v, method.getReturnType())), () -> Optional.of(method).flatMap(m -> Arrays.stream(m.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(Generator.class)).map(a -> {
            Class<? extends ValueGenerator> generator = a.annotationType().getAnnotation(Generator.class).value();
            try {
                return generator.getConstructor(a.annotationType(), CoreAccessor.class).newInstance(a, core).generate();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("constructor 'public %s(%s annotation, CoreAccessor core) {...}' might be missing", generator.getSimpleName(), a.annotationType().getSimpleName()), e);
            }
        }).findFirst()), () -> Optional.of(method).map(m -> m.getAnnotation(Generator.class)).map(Generator::value).map(c -> {
            try {
                return ((ValueGenerator)c.getConstructor(CoreAccessor.class).newInstance(core)).generate();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("constructor 'public %s(CoreAccessor core) {...}' might be missing", c.getSimpleName()), e);
            }
        })).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    private static String resolveValue(Value annotation, CoreAccessor core) {
        return annotation.type() == ValueType.CONFIG_KEY ? core.getConfig().get(annotation.value()) : annotation.value();
    }

    private static <DATA> Method getMethod(Class<DATA> clazz, Function<DATA, ?> invocation) {
        ArrayList<Method> accumulator = new ArrayList<Method>();
        Object proxy = Proxy.newProxyInstance(MethodCapturingInvocationHandler.class.getClassLoader(), new Class[]{clazz}, new MethodCapturingInvocationHandler<DATA>(clazz, accumulator));
        invocation.apply(proxy);
        if (accumulator.isEmpty()) {
            throw new IllegalArgumentException("Expected method reference but no interface method was called. Please pass Java 8+ method reference such as 'MyDataObject::myProperty'");
        }
        if (accumulator.size() > 1) {
            throw new IllegalArgumentException("Expected single method reference multiple interface methods were called. Please pass Java 8+ method reference such as 'MyDataObject::myProperty'");
        }
        return (Method)accumulator.iterator().next();
    }

    private static Date parseDate(Method method, String value) {
        try {
            return new SimpleDateFormat(Optional.of(method.getAnnotation(Pattern.class)).map(Pattern::value).orElse("")).parse(value.trim());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class CsvHandler<DATA>
    implements CsvProvider {
        private final Class<DATA> clazz;
        private final Stream<DATA> items;

        public CsvHandler(Class<DATA> clazz, Stream<DATA> items) {
            this.clazz = clazz;
            this.items = items;
        }

        @Override
        public String asCsv(boolean withHeader) {
            String values = this.items.map(v -> Arrays.stream(this.clazz.getMethods()).filter(m -> m.isAnnotationPresent(Name.class)).sorted(Comparator.comparing(m -> m.getAnnotation(Name.class).order())).map(m -> {
                try {
                    return Pair.of((Object)m, (Object)m.invoke(v, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("Something went very wrong", e);
                }
            }).map(p -> {
                if (p.getValue() instanceof Date && ((Method)p.getKey()).isAnnotationPresent(Pattern.class)) {
                    return new SimpleDateFormat(((Method)p.getKey()).getAnnotation(Pattern.class).value()).format(p.getValue());
                }
                if (((Method)p.getKey()).isAnnotationPresent(Pattern.class)) {
                    return String.format(((Method)p.getKey()).getAnnotation(Pattern.class).value(), p.getValue());
                }
                return ConvertUtils.convert((Object)p.getValue());
            }).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
            return withHeader ? this.createHeader() + "\n" + values : values;
        }

        private String createHeader() {
            return Arrays.stream(this.clazz.getMethods()).filter(m -> m.isAnnotationPresent(Name.class)).map(m -> m.getAnnotation(Name.class)).sorted(Comparator.comparing(Name::order)).map(Name::value).collect(Collectors.joining(","));
        }

        private static Stream<Map<String, Object>> parse(String csv, Class<?> clazz) {
            String[] rows = csv.split("\n");
            Map<String, Method> nameMethodMap = Arrays.stream(clazz.getMethods()).filter(m -> m.isAnnotationPresent(Name.class)).collect(Collectors.toMap(m -> m.getAnnotation(Name.class).value(), m -> m));
            Method[] methods = (Method[])Arrays.stream(rows[0].split(",")).map(String::trim).map(n -> {
                Method method = (Method)nameMethodMap.get(n);
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Could not find @Name(\"%s\") annotated method on %s", n, clazz.getSimpleName()));
                }
                return method;
            }).toArray(Method[]::new);
            return Arrays.stream(rows, 1, rows.length).map(r -> r.split(",")).map(r -> IntStream.range(0, methods.length).boxed().collect(Collectors.toMap(i -> methods[i].getName(), i -> Date.class.isAssignableFrom(methods[i].getReturnType()) ? DataProxyFactory.parseDate(methods[i], r[i]) : ConvertUtils.convert((String)r[i].trim(), methods[i].getReturnType()))));
        }
    }

    private static class ItemProxyInvocationHandler<DATA>
    implements InvocationHandler {
        private final Class<DATA> clazz;
        private final CoreAccessor core;
        protected final Map<String, Object> values;

        public ItemProxyInvocationHandler(Class<DATA> clazz, CoreAccessor core, Map<String, Object> values) {
            this.clazz = clazz;
            this.core = core;
            this.values = values;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CoreAccessor.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this.core, args);
            }
            if (CsvProvider.class.equals(method.getDeclaringClass())) {
                return method.invoke(new CsvHandler<Object>(this.clazz, Stream.of(proxy)), args);
            }
            if (StreamProvider.class.equals(method.getDeclaringClass()) && "stream".equals(method.getName())) {
                return Stream.of(proxy);
            }
            if (Overridable.class.equals(method.getDeclaringClass()) && "with".equals(method.getName()) && args.length == 2) {
                this.values.put(DataProxyFactory.getMethod(this.clazz, (Function)args[0]).getName(), args[1]);
                return proxy;
            }
            if (Overridable.class.equals(method.getDeclaringClass()) && "reset".equals(method.getName()) && args.length == 1) {
                this.values.remove(DataProxyFactory.getMethod(this.clazz, (Function)args[0]).getName());
                return proxy;
            }
            return this.values.computeIfAbsent(method.getName(), name -> DataProxyFactory.computeValue(this.core, proxy, method, args));
        }
    }

    private static class DataProxyInvocationHandler<DATA>
    implements InvocationHandler {
        private final Class<DATA> clazz;
        private final CoreAccessor core;
        private Stream<DATA> items;

        private DataProxyInvocationHandler(Class<DATA> clazz, CoreAccessor core, Stream<DATA> items) {
            this.clazz = clazz;
            this.core = core;
            this.items = items;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CoreAccessor.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this.core, args);
            }
            if (CsvProvider.class.equals(method.getDeclaringClass())) {
                return method.invoke(new CsvHandler<DATA>(this.clazz, this.items), args);
            }
            if (StreamProvider.class.equals(method.getDeclaringClass()) && "stream".equals(method.getName())) {
                return this.items;
            }
            if (DataProvider.class.equals(method.getDeclaringClass()) && "with".equals(method.getName()) && args.length == 2) {
                this.items = this.items.peek(i -> ((ItemProxyInvocationHandler)Proxy.getInvocationHandler((Object)i)).values.put(DataProxyFactory.getMethod(this.clazz, (Function)args[0]).getName(), args[1]));
                return proxy;
            }
            if (DataProvider.class.equals(method.getDeclaringClass()) && "reset".equals(method.getName()) && args.length == 1) {
                this.items = this.items.peek(i -> ((ItemProxyInvocationHandler)Proxy.getInvocationHandler((Object)i)).values.remove(DataProxyFactory.getMethod(this.clazz, (Function)args[0]).getName()));
                return proxy;
            }
            throw new UnsupportedOperationException("not implemented yet");
        }
    }

    private static class MethodCapturingInvocationHandler<DATA>
    implements InvocationHandler {
        private final Class<DATA> clazz;
        private final Collection<Method> accumulator;

        public MethodCapturingInvocationHandler(Class<DATA> clazz, Collection<Method> accumulator) {
            this.clazz = clazz;
            this.accumulator = accumulator;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            this.accumulator.add(method);
            return null;
        }
    }
}

