/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import dev.pumpo5.integrations.JiraExtensionHelper;
import dev.pumpo5.integrations.JiraTicket;
import dev.pumpo5.integrations.Ticket;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class EnableIfTicketPresentCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@JiraTicket is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional optional = AnnotationSupport.findAnnotation((Optional)context.getElement(), JiraTicket.class);
        if (!optional.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        String id = ((JiraTicket)optional.get()).value();
        Ticket jiraTicket = JiraExtensionHelper.getClient(context).fetchJiraTicketByKey(id, Ticket.class);
        if (jiraTicket.id == null) {
            return ConditionEvaluationResult.disabled((String)String.format("Test is mapped to non-existent jira ticket [%s]", id));
        }
        return ConditionEvaluationResult.enabled((String)"Jira Ticket for the test exists");
    }
}

