/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.util.RetryUtils;
import dev.pumpo5.integrations.Ticket;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClient.class);
    private static final String ISSUE_DETAIL_URL_TEMPLATE = "rest/api/2/issue/%s";
    private static final String ISSUE_TRANSITIONS_URL_TEMPLATE = "rest/api/2/issue/%s/transitions";
    private static final String FIELD_TYPES_URL_TEMPLATE = "rest/api/2/field";
    public static final String ATTACHMENT_URL_TEMPLATE = "rest/api/2/attachment/%s";
    public static final String TRANSITIONS_DELIMITER = ",";
    public static final int MAX_RETRIES = 3;
    public static final int MAX_RETRIES_CHECK_STATUS = 10;
    public static final Duration RETRY_INTERVAL_CHECK_STATUS = Duration.ofSeconds(30L);
    public static final String PUMPO_ATTACHMENT_PREFIX = "pn5::attachment::";
    public static final Duration RETRY_INTERVAL = Duration.ofSeconds(30L);
    private final WebTarget target;
    private Map<String, FieldType> customFieldType;
    private final Config config;

    public JiraClient(Config config) {
        this.config = config;
        ClientConfig clientConfig = new ClientConfig().register(JacksonFeature.class).register(JacksonJsonProvider.class).register(MultiPartFeature.class).register(requestContext -> requestContext.getHeaders().add((Object)"Authorization", (Object)this.getAuthHeader()));
        if (Boolean.parseBoolean(config.get("jira.log.enable"))) {
            clientConfig.register((Object)new LoggingFeature(LogManager.getLogManager().getLogger("JiraClientLogger"), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(0x100000)));
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig).sslContext(SslConfigurator.newInstance().createSSLContext());
        String path = config.get("jira.truststore.path");
        String password = config.get("jira.truststore.password");
        try {
            if (path != null) {
                password = password != null ? password : "";
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream inputStream = Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) ? new FileInputStream(path) : this.getClass().getClassLoader().getResourceAsStream(path);
                trustStore.load(inputStream, password.toCharArray());
                clientBuilder.trustStore(trustStore);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.warn("Failed to load custom truststore in the JIRA client", (Throwable)e);
        }
        this.target = clientBuilder.build().target(ConfigHelper.getOrThrow(config, "jira.server"));
    }

    public WebTarget target() {
        return this.target;
    }

    public Ticket fetchJiraTicketByKey(String keyOrId) {
        return this.fetchJiraTicketByKey(keyOrId, Ticket.class);
    }

    public boolean transitionIssue(String testCaseKey, String transitionsName) {
        LOG.trace("Trying to transition an issue {} using transition {}", (Object)testCaseKey, (Object)transitionsName);
        return Arrays.stream(transitionsName.split(TRANSITIONS_DELIMITER)).map(t -> this.getTransitionId(testCaseKey, (String)t).map(transitionId -> {
            int attempts = 0;
            Response response = null;
            while (attempts < 10) {
                try {
                    String url = String.format(ISSUE_TRANSITIONS_URL_TEMPLATE, testCaseKey);
                    LOG.trace("POSTing to URL: {}", (Object)url);
                    response = RetryUtils.invokeWithRetry(3, RETRY_INTERVAL, this.target.path(url).request().buildPost(Entity.json((Object)new TransitionIssue(new Transition((String)transitionId)))));
                    LOG.trace("Got response, status code: {}", (Object)response.getStatus());
                    LOG.trace("Response: {}", (Object)response);
                    if (response.getStatus() == 204) {
                        LOG.trace("Transition issue {} using transition {} was successful", (Object)testCaseKey, (Object)transitionsName);
                        Boolean bl = true;
                        return bl;
                    }
                    LOG.trace("Transition for issue {} using transition {} failed with status: {}. Retrying...", new Object[]{testCaseKey, transitionsName, response.getStatus()});
                    Thread.sleep(RETRY_INTERVAL_CHECK_STATUS.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                    ++attempts;
                }
            }
            return false;
        }).orElse(false)).filter(r -> r).findFirst().orElse(false);
    }

    public Optional<String> getTransitionId(String testCaseKey, String transitionName) {
        Response response = RetryUtils.invokeWithRetry(3, RETRY_INTERVAL, this.target.path(String.format(ISSUE_TRANSITIONS_URL_TEMPLATE, testCaseKey)).queryParam("expand", new Object[]{"transitions.fields"}).request().buildGet());
        Transition[] transitions = ((Transitions)response.readEntity(Transitions.class)).transitions;
        if (transitions != null) {
            return Arrays.stream(transitions).filter(t -> transitionName.equals(t.name)).map(t -> t.id).findFirst();
        }
        return Optional.empty();
    }

    public <T> T fetchJiraTicketByKey(String key, Class<T> clazz) {
        Response response = RetryUtils.invokeWithRetry(3, RETRY_INTERVAL, this.target.path(String.format(ISSUE_DETAIL_URL_TEMPLATE, key)).request().buildGet());
        switch (response.getStatus()) {
            case 200: {
                return (T)response.readEntity(clazz);
            }
            case 404: {
                throw new IllegalStateException(String.format("Cannot fetch Jira ticket by key [%s]. Things you should check: 1) that ticket exists, 2) that you have rights to view it and 3) that you correctly configured credentials for Jira Client", key));
            }
        }
        throw new IllegalStateException(String.format("Jira server returned unexpected status code: %s", response.getStatus()));
    }

    public <T> T fetchJiraTicketById(Integer id, Class<T> clazz) {
        Response response = RetryUtils.invokeWithRetry(3, RETRY_INTERVAL, this.target.path(String.format(ISSUE_DETAIL_URL_TEMPLATE, id.toString())).request().buildGet());
        switch (response.getStatus()) {
            case 200: {
                return (T)response.readEntity(clazz);
            }
            case 404: {
                throw new IllegalStateException(String.format("Cannot fetch Jira ticket by id [%s]. Things you should check: 1) that ticket exists, 2) that you have rights to view it and 3) that you correctly configured credentials for Jira Client", id));
            }
        }
        throw new IllegalStateException(String.format("Jira server returned unexpected status code: %s", response.getStatus()));
    }

    public <T> T fetchJiraTicketsByPath(String path, Class<T> type) {
        Response response = RetryUtils.invokeWithRetry(3, RETRY_INTERVAL, this.target.path(path).request().buildGet());
        switch (response.getStatus()) {
            case 200: {
                return (T)response.readEntity(type);
            }
            case 404: {
                throw new IllegalStateException(String.format("Got a 404 response when fetching JIRA tickets on following path: %s", path));
            }
        }
        throw new IllegalStateException(String.format("Jira server returned unexpected status code: %s", response.getStatus()));
    }

    private InputStream getInputStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    public String getUrl() {
        return ConfigHelper.getOrThrow(this.config, "jira.server");
    }

    public String getAuthHeader() {
        String username = ConfigHelper.getOrThrow(this.config, "jira.username");
        String password = ConfigHelper.getOrThrow(this.config, "jira.password");
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    public void removeAttachment(String id) {
        LOG.info("Removing attachment with id: {}", (Object)id);
        String path = String.format(ATTACHMENT_URL_TEMPLATE, id);
        Response response = this.target.path(path).request().delete();
        switch (response.getStatus()) {
            case 204: {
                return;
            }
            case 404: {
                throw new IllegalStateException(String.format("Cannot delete attachment, got a 404 response on following path: %s", path));
            }
        }
        throw new IllegalStateException(String.format("Jira server returned unexpected status code: %s", response.getStatus()));
    }

    public void removePumpoAttachments(String jiraKey) {
        Attachment[] attachments;
        FieldsTicket fieldsTicket = this.fetchJiraTicketByKey(jiraKey, FieldsTicket.class);
        for (Attachment attachment : attachments = fieldsTicket.fields.attachment) {
            if (!attachment.author.name.equals(this.config.get("jira.username")) || !attachment.filename.startsWith(PUMPO_ATTACHMENT_PREFIX)) continue;
            this.removeAttachment(attachment.id);
        }
    }

    private Map<String, FieldType> getCustomFields() {
        FieldType[] fields = RetryUtils.retry(3, RETRY_INTERVAL, () -> (FieldType[])this.target.path(FIELD_TYPES_URL_TEMPLATE).request().get(FieldType[].class), RetryUtils.NETWORK_EXCEPTIONS);
        return Arrays.stream(fields).filter(fieldType -> fieldType.customTypeKey != null).collect(Collectors.toMap(fieldType -> fieldType.customTypeKey, fieldType -> fieldType, (left, right) -> left));
    }

    public String getCustomFieldId(String schemaTypeKey) {
        FieldType fieldType;
        if (this.customFieldType == null) {
            try {
                this.customFieldType = this.getCustomFields();
            }
            catch (Exception e) {
                LOG.error("Failed getting custom fields from Jira:", (Throwable)e);
                this.customFieldType = new HashMap<String, FieldType>();
            }
        }
        if ((fieldType = this.customFieldType.get(schemaTypeKey)) != null) {
            return fieldType.id;
        }
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Transitions {
        public Transition[] transitions;

        private Transitions() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Transition {
        public String id;
        public String name;

        public Transition() {
        }

        public Transition(String id) {
            this.id = id;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class FieldsTicket {
        public Fields fields;

        private FieldsTicket() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Fields {
        public Attachment[] attachment;

        private Fields() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Attachment {
        public String self;
        public String id;
        public String filename;
        public Author author;
        public String created;
        public int size;
        public String mimeType;
        public String content;
        public String thumbnail;

        private Attachment() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Author {
        public String self;
        public String name;
        public String key;
        public String emailAddress;
        public String displayName;
        public boolean active;
        public String timeZone;

        private Author() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class FieldType {
        public String id;
        public String customTypeKey;

        private FieldType() {
        }

        public void setSchema(JsonNode schema) {
            JsonNode custom = schema.get("custom");
            if (custom != null) {
                this.customTypeKey = custom.asText();
            }
        }
    }

    private static class TransitionIssue {
        public Transition transition;
        public Update update;

        public TransitionIssue() {
        }

        public TransitionIssue(Transition transition) {
            this.transition = transition;
        }
    }

    private static class Update {
        private Update() {
        }
    }
}

