/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.integrations.JiraClient;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClientExtension
implements BeforeAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientExtension.class);

    public void beforeAll(ExtensionContext context) {
        Config config = ConfigHelper.getConfig(context);
        if (config.containsKey("jira.server") && config.containsKey("jira.username") && config.containsKey("jira.password")) {
            this.initJiraClient(context);
        }
    }

    private void initJiraClient(ExtensionContext context) {
        context.getStore(ExtensionContext.Namespace.GLOBAL).getOrComputeIfAbsent(JiraClient.class, k -> new JiraClient(ConfigHelper.getConfig(context)));
    }
}

