/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.PumpoEvents;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidStartScreenRecordingOptions;
import io.appium.java_client.ios.IOSStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.CanRecordScreen;
import io.qameta.allure.Attachment;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;

public class RecordVideoClient {
    private static PumpoEvents logger = new PumpoEvents();

    @Attachment(value="Video", type="video/mp4", fileExtension=".mp4")
    public static byte[] stopVideo(WebDriver driver) {
        try {
            String video = ((CanRecordScreen)driver).stopRecordingScreen();
            byte[] decodeVideo = Base64.getMimeDecoder().decode(video);
            logger.log(LogLevel.INFO, "Video recording stopped and saved to allure report...", new Object[0]);
            return decodeVideo;
        }
        catch (Exception e) {
            logger.log(LogLevel.WARN, "Saving video failed (may recording not started) cause {}", e);
            return new byte[0];
        }
    }

    private static void startAndroidRecording(WebDriver driver, String timeLimit, String resolution) {
        try {
            AndroidStartScreenRecordingOptions startOptions = new AndroidStartScreenRecordingOptions().withVideoSize(resolution).withBitRate(500000).withTimeLimit(Duration.ofMinutes(Integer.parseInt(timeLimit)));
            ((CanRecordScreen)driver).startRecordingScreen((BaseStartScreenRecordingOptions)startOptions);
            logger.log(LogLevel.INFO, "Video recording started for android...", new Object[0]);
        }
        catch (Exception e) {
            logger.log(LogLevel.WARN, "Video recording failed cause {}", e);
        }
    }

    private static void startIosRecording(WebDriver driver, String timeLimit, String resolution) {
        try {
            IOSStartScreenRecordingOptions startOptions = new IOSStartScreenRecordingOptions().withVideoQuality(IOSStartScreenRecordingOptions.VideoQuality.LOW).withVideoScale(resolution).withVideoType("libx264").withTimeLimit(Duration.ofMinutes(Integer.parseInt(timeLimit)));
            ((CanRecordScreen)driver).startRecordingScreen((BaseStartScreenRecordingOptions)startOptions);
            logger.log(LogLevel.INFO, "Video recording started for ios...", new Object[0]);
        }
        catch (Exception e) {
            logger.log(LogLevel.WARN, "Video recording failed cause {}", e);
        }
    }

    public static void startRecording(WebDriver driver, Config config) {
        if (driver != null && config.getBoolean("pn5.video.enabled")) {
            if (Objects.requireNonNull(RecordVideoClient.getCapabilities(driver)).getCapability("pn5:mobile:platform").equals("pn5:mobile:android")) {
                RecordVideoClient.startAndroidRecording(driver, config.getOrDefault((Object)"pn5.video.time.limit", "3"), config.getOrDefault((Object)"pn5.video.resolution", "720x1280"));
            } else if (Objects.requireNonNull(RecordVideoClient.getCapabilities(driver)).getCapability("pn5:mobile:platform").equals("pn5:mobile:ios")) {
                RecordVideoClient.startIosRecording(driver, config.getOrDefault((Object)"pn5.video.time.limit", "3"), config.getOrDefault((Object)"pn5.video.resolution", "720x1280"));
            } else {
                logger.log(LogLevel.INFO, "Starting record for this platform is not supported (Only supported platform are IOS and ANDROID).", new Object[0]);
            }
        }
    }

    private static Capabilities getCapabilities(WebDriver driver) {
        if (driver instanceof AppiumDriver) {
            return ((AppiumDriver)driver).getCapabilities();
        }
        return null;
    }
}

