/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import dev.pumpo5.config.Config;
import dev.pumpo5.integrations.JiraClientExtension;
import dev.pumpo5.integrations.XrayCloudHelper;
import io.restassured.RestAssured;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayCloudClient {
    private final Logger LOG = LoggerFactory.getLogger(JiraClientExtension.class);
    private final String XRAY_BASE_URL;
    private final String XRAY_API_SUFFIX;
    private final String XRAY_CLIENT_ID;
    private final String XRAY_CLIENT_SECRET;
    private final String JIRA_BASE_URL;
    private final String JIRA_API_SUFFIX;
    private final String JIRA_USERNAME;
    private final String JIRA_TOKEN;
    private final String QUE_REPORTING_URL;
    private final String QUE_REPORTING_PATH;
    private String XRAY_AUTH_TOKEN = null;

    public XrayCloudClient(Config config) {
        this.XRAY_BASE_URL = config.get("base.url");
        this.XRAY_API_SUFFIX = config.get("api.suffix");
        this.XRAY_CLIENT_ID = config.get("client.id");
        this.XRAY_CLIENT_SECRET = config.get("client.secret");
        this.JIRA_BASE_URL = config.get("jira.base.url");
        this.JIRA_API_SUFFIX = config.get("jira.api.suffix");
        this.JIRA_USERNAME = config.get("jira.username");
        this.JIRA_TOKEN = config.get("jira.token");
        this.QUE_REPORTING_URL = config.get("que.reporting.url");
        this.QUE_REPORTING_PATH = config.get("que.reporting.path");
        if (this.QUE_REPORTING_URL.isEmpty()) {
            this.XRAY_AUTH_TOKEN = this.getXrayCloudToken();
        }
    }

    public void addTestsToTestExecIfNotExist(ArrayList<String> annotatedTestCasesArray, String testExecId) {
        ArrayList<String> tempAnnotatedTestCasesArray = new ArrayList<String>(annotatedTestCasesArray);
        ArrayList<String> testsInTestExecution = this.getTestIdsFromTestExecution(testExecId);
        tempAnnotatedTestCasesArray.removeAll(testsInTestExecution);
        if (!tempAnnotatedTestCasesArray.isEmpty()) {
            tempAnnotatedTestCasesArray.forEach(s -> this.addTestExecutionsToTest((String)s, this.transformIssueKeyToIssueId(testExecId)));
            this.LOG.info("Tests {} was added to test execution {}...", tempAnnotatedTestCasesArray, (Object)testExecId);
        }
    }

    private String getXrayCloudToken() {
        RestAssured.baseURI = this.XRAY_BASE_URL + this.XRAY_API_SUFFIX + "/authenticate";
        String body = String.format("{ \"client_id\": \"%s\",\"client_secret\": \"%s\" }", this.XRAY_CLIENT_ID, this.XRAY_CLIENT_SECRET);
        Response response = (Response)((RequestSpecification)RestAssured.given().contentType("application/json").body(body).when().log().ifValidationFails(LogDetail.ALL)).post();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
        this.LOG.info("Xray Cloud token was generated...");
        return response.header("x-access-token");
    }

    public String transformIssueKeyToIssueId(String issueKey) {
        RestAssured.baseURI = String.format(this.JIRA_BASE_URL + this.JIRA_API_SUFFIX + "/issue/%s", issueKey);
        Response response = (Response)((RequestSpecification)RestAssured.given().contentType("application/json").when().header("Authorization", (Object)XrayCloudHelper.getBasicAuthenticationHeader(this.JIRA_USERNAME, this.JIRA_TOKEN), new Object[0]).log().ifValidationFails(LogDetail.ALL)).get();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
        return XrayCloudHelper.parseResponseAsString(response, "id");
    }

    public void updateTestRunStatus(String testRunId, Enum<XrayCloudHelper.testStatus> testStatus2) {
        RestAssured.baseURI = this.XRAY_BASE_URL + this.XRAY_API_SUFFIX + "/graphql";
        String query = "mutation {\n    updateTestRunStatus( id: \"" + testRunId + "\", status: \"" + testStatus2 + "\")\n}";
        String jsonString = XrayCloudHelper.graphqlToJson(query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().header("Authorization", (Object)("Bearer " + this.XRAY_AUTH_TOKEN), new Object[0]).contentType("application/json").body(jsonString).when().log().ifValidationFails(LogDetail.ALL)).post()).then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
        this.LOG.info("Test run {} was updated to status {}...", (Object)testRunId, testStatus2);
    }

    public void addTestExecutionsToTest(String testId, String testExecId) {
        RestAssured.baseURI = this.XRAY_BASE_URL + this.XRAY_API_SUFFIX + "/graphql";
        String query = "mutation {\n    addTestExecutionsToTest(\n        issueId: \"" + testId + "\",\n        testExecIssueIds: [\"" + testExecId + "\"]\n    ) {\n        addedTestExecutions\n        warning\n    }\n}";
        String jsonString = XrayCloudHelper.graphqlToJson(query);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().header("Authorization", (Object)("Bearer " + this.XRAY_AUTH_TOKEN), new Object[0]).contentType("application/json").body(jsonString).when().log().ifValidationFails(LogDetail.ALL)).post()).then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
    }

    public ArrayList<String> getTestIdsFromTestExecution(String testExecId) {
        testExecId = this.transformIssueKeyToIssueId(testExecId);
        String responseJsonPath = "data.getTestExecution.tests.results";
        RestAssured.baseURI = this.XRAY_BASE_URL + this.XRAY_API_SUFFIX + "/graphql";
        String query = "{\n    getTestExecution(issueId: \"" + testExecId + "\") {\n        issueId\n        tests(limit: 100) {\n            total\n            start\n            limit\n            results {\n                issueId\n                testType {\n                    name\n                }\n            }\n        }\n    }\n}";
        String jsonString = XrayCloudHelper.graphqlToJson(query);
        Response response = (Response)((RequestSpecification)RestAssured.given().header("Authorization", (Object)("Bearer " + this.XRAY_AUTH_TOKEN), new Object[0]).contentType("application/json").body(jsonString).when().log().ifValidationFails(LogDetail.ALL)).post();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
        return XrayCloudHelper.transformIssueIdTestCasesAsArray(response, responseJsonPath);
    }

    public String getTestRunIdForTest(String testId, String testExecId) {
        String responseJsonPath = "data.getTestRun.id";
        RestAssured.baseURI = this.XRAY_BASE_URL + this.XRAY_API_SUFFIX + "/graphql";
        String query = "{\n    getTestRun( testIssueId: \"" + testId + "\", testExecIssueId: \"" + testExecId + "\") {\n        id\n        status {\n            name\n            color\n            description\n        }\n        gherkin\n        examples {\n            id\n            status {\n                name\n                color\n                description\n            }\n        }\n    }\n}";
        String jsonString = XrayCloudHelper.graphqlToJson(query);
        Response response = (Response)((RequestSpecification)RestAssured.given().header("Authorization", (Object)("Bearer " + this.XRAY_AUTH_TOKEN), new Object[0]).contentType("application/json").body(jsonString).when().log().ifValidationFails(LogDetail.ALL)).post();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)response.then()).log().ifValidationFails(LogDetail.ALL)).assertThat()).statusLine("HTTP/1.1 200 OK");
        return XrayCloudHelper.parseResponseAsString(response, responseJsonPath);
    }

    public void sendReportToQue(String testId, String testExecId, Enum<XrayCloudHelper.testStatus> testStatus2) {
        try {
            RestAssuredConfig config = RestAssuredConfig.config().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)3000).setParam("http.socket.timeout", (Object)3000).setParam("http.connection-manager.timeout", (Object)3000));
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(config).queryParam("test_id", new Object[]{testId}).queryParam("test_exec_id", new Object[]{testExecId}).queryParam("test_status", new Object[]{testStatus2}).when().get(String.format(this.QUE_REPORTING_URL + this.QUE_REPORTING_PATH, new Object[0]), new Object[0])).then()).assertThat()).statusLine("HTTP/1.1 200 OK");
            this.LOG.info("Report sent to Que for testId: {}, testExecId: {}, testStatus: {}", new Object[]{testId, testExecId, testStatus2});
        }
        catch (AssertionError | Exception e) {
            this.LOG.warn("Failed to send report to Que for testId: {}, testExecId: {}, testStatus: {}", new Object[]{testId, testExecId, testStatus2});
        }
    }
}

