/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.integrations;

import dev.pumpo5.config.Config;
import dev.pumpo5.integrations.JiraClientExtension;
import dev.pumpo5.integrations.XrayCloudClient;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Base64;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayCloudHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientExtension.class);

    public static XrayCloudClient getClient(Config config) {
        return new XrayCloudClient(config);
    }

    protected static ArrayList<String> transformIssueIdTestCasesAsArray(Response response, String jsonPath) {
        ArrayList<String> automationTests = new ArrayList<String>();
        for (String s : XrayCloudHelper.parseResponseAsArray(response, jsonPath)) {
            automationTests.add(s.replaceAll("[^0-9]", ""));
        }
        return automationTests;
    }

    protected static String[] parseResponseAsArray(Response response, String jsonPath) {
        JsonPath jsonPathEvaluator = response.jsonPath();
        Object issueIdObj = jsonPathEvaluator.getJsonObject(jsonPath);
        return issueIdObj.toString().split("},");
    }

    protected static String parseResponseAsString(Response response, String jsonPath) {
        JsonPath jsonPathEvaluator = response.jsonPath();
        Object issueIdObj = jsonPathEvaluator.getJsonObject(jsonPath);
        return issueIdObj.toString();
    }

    protected static String graphqlToJson(String payload) {
        JSONObject json = new JSONObject();
        json.put("query", (Object)payload);
        return json.toString();
    }

    protected static String getBasicAuthenticationHeader(String username, String token) {
        String valueToEncode = username + ":" + token;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public static enum testStatus {
        FAILED("FAILED"),
        PASSED("PASSED"),
        TODO("TO DO"),
        EXECUTING("EXECUTING");


        private testStatus(String testStatus2) {
        }
    }
}

