/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.mobile;

import dev.pumpo5.config.Config;
import dev.pumpo5.config.ConfigHelper;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.ExtensionUtils;
import dev.pumpo5.core.webdriver.WebDriverClientExtension;
import dev.pumpo5.mobile.Device;
import dev.pumpo5.mobile.MobileApplication;
import dev.pumpo5.mobile.MobileApplicationSupport;
import dev.pumpo5.mobile.MobileApplicationTestTemplateInvocationContext;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

public class MobileApplicationExtension
extends WebDriverClientExtension<MobileApplication>
implements TestTemplateInvocationContextProvider {
    public MobileApplicationExtension() {
        super(MobileApplication.class);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Optional.of(parameterContext).map(ParameterContext::getParameter).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Device.class)) <= 1).map(Parameter::getType).filter(MobileApplication.class::isAssignableFrom).isPresent();
    }

    @Override
    protected MobileApplication createProxy(Class<? extends MobileApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        return MobileApplicationSupport.createProxy(type, driverUrl, capabilities, core);
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        long count = Arrays.stream(context.getRequiredTestMethod().getParameters()).filter(p -> MobileApplication.class.isAssignableFrom(p.getType())).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Device.class)) > 1).count();
        if (count > 1L) {
            throw new IllegalArgumentException("Multiple MobileApplication parameters sporting multiple @Device annotations each are not supported!");
        }
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Config config = ConfigHelper.getConfig(context);
        Stream<TestTemplateInvocationContext> contexts = Arrays.stream(context.getRequiredTestMethod().getParameters()).filter(p -> MobileApplication.class.isAssignableFrom(p.getType())).filter(p -> ArrayUtils.getLength((Object)p.getAnnotationsByType(Device.class)) > 1).flatMap(p -> this.getDeviceDescriptors((Parameter)p, config)).map(t -> new MobileApplicationTestTemplateInvocationContext((String)t.getLeft(), (String)t.getMiddle(), (Map)t.getRight(), context.getRequiredTestMethod()));
        return ExtensionUtils.defaultIfEmpty(contexts, () -> Stream.of(new TestTemplateInvocationContext[0]));
    }

    private Stream<Triple<String, String, Map<String, Object>>> getDeviceDescriptors(Parameter parameter, Config config) {
        return ExtensionUtils.getDeviceDescriptors(parameter, Device.class, Device::description, Device::capabilities, Device::inheritCapabilities, config);
    }
}

