/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.mobile;

import com.browserstack.local.Local;
import dev.pumpo5.PumpoException;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.core.webdriver.WebDriverClientExtension;
import dev.pumpo5.integrations.RecordVideoClient;
import dev.pumpo5.mobile.MobileAgent;
import dev.pumpo5.mobile.MobileApplication;
import dev.pumpo5.mobile.MobileProxyFactory;
import dev.pumpo5.mobile.RemoteMobileAgent;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MobileApplicationSupport
extends ApplicationSupport<MobileApplication>
implements MobileApplication {
    private MobileProxyFactory factory;
    private MobileAgent agent;
    private Local bstackLocal;

    private MobileApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends MobileApplication> APPLICATION_OBJECT createProxy(Class<?> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("proxy type must be an interface but was %s", type.getSimpleName()));
        }
        if (!MobileApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("proxy type must extend MobileApplication");
        }
        return (APPLICATION_OBJECT)((MobileApplication)Proxy.newProxyInstance(MobileApplicationSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<MobileApplicationSupport>(type, new MobileApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    protected void startSessionImplementation() {
        this.prepareBrowserstackLocal();
        this.agent = this.newAgent();
        RecordVideoClient.startRecording(this.agent.getDriver(), this.core.getConfig());
        this.factory = new MobileProxyFactory(this.agent, this.core);
    }

    void prepareBrowserstackLocal() {
        if (this.capabilities.containsKey("pn5:bstack:local") && this.getConfig().getOrDefault((Object)"pn5.browserstack.local.create", true)) {
            this.bstackLocal = new Local();
            HashMap<String, String> bstackLocalOptions = new HashMap<String, String>();
            String bstackKey = this.getConfig().get("pn5.browserstack.key");
            if (bstackKey == null) {
                throw new PumpoException(String.format("Failed to start BrowserStackLocal: missing browserstack key. Please add it to your config as '%s'", "pn5.browserstack.key"));
            }
            bstackLocalOptions.put("key", bstackKey);
            if (this.getConfig().containsKey("pn5.browserstack.local.force")) {
                bstackLocalOptions.put("forcelocal", this.getConfig().get("pn5.browserstack.local.force"));
            }
            if (this.getConfig().containsKey("pn5.browserstack.proxy.host")) {
                bstackLocalOptions.put("proxyHost", this.getConfig().get("pn5.browserstack.proxy.host"));
            }
            if (this.getConfig().containsKey("pn5.browserstack.proxy.port")) {
                bstackLocalOptions.put("proxyPort", this.getConfig().get("pn5.browserstack.proxy.port"));
            }
            if (this.getConfig().containsKey("pn5.browserstack.proxy.force")) {
                bstackLocalOptions.put("forceproxy", this.getConfig().get("pn5.browserstack.proxy.force"));
            }
            String bstackSessionIdentifier = UUID.randomUUID().toString();
            bstackLocalOptions.put("localIdentifier", bstackSessionIdentifier);
            WebDriverClientExtension.ensureCapabilitiesGroup(this.capabilities, "bstack:options").put("localIdentifier", bstackSessionIdentifier);
            try {
                this.bstackLocal.start(bstackLocalOptions);
            }
            catch (Exception e) {
                throw new PumpoException("Failed to start BrowserStackLocal binary", e);
            }
        }
    }

    @Override
    public RemoteMobileAgent newAgent() {
        return new RemoteMobileAgent(this.capabilities, this.driverUrl, this.core.getConfig());
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
            this.factory = null;
        }
        if (this.bstackLocal != null) {
            try {
                this.bstackLocal.stop();
            }
            catch (Exception e) {
                throw new PumpoException("Failed to stop BrowserStackLocal binary", e);
            }
        }
    }

    public <PAGE_OBJECT> PAGE_OBJECT open(Class<PAGE_OBJECT> page) {
        this.checkSessionStarted();
        if (page.isInterface()) {
            return this.factory.prepareProxy(page, true, this.core);
        }
        return this.factory.prepareClassProxy(page);
    }

    @Override
    public MobileAgent getAgent() {
        return this.agent;
    }
}

