/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.mobile;

import dev.pumpo5.PumpoException;
import dev.pumpo5.actions.Click;
import dev.pumpo5.actions.DoubleClick;
import dev.pumpo5.actions.ScrollIntoView;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.util.TestUtils;
import dev.pumpo5.core.webdriver.ProxyFactory;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.mobile.MobileAgent;
import dev.pumpo5.mobile.MobileProxyInvocationHandler;
import dev.pumpo5.web.actions.Select;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import org.openqa.selenium.WebDriverException;

public final class MobileProxyFactory
extends ProxyFactory {
    private final MobileAgent agent;

    public MobileProxyFactory(MobileAgent agent, CoreAccessor core) {
        super(agent, core);
        this.agent = agent;
    }

    @Override
    public void enterInvocation() {
        this.agent.enterSelenideContext();
    }

    @Override
    public void exitInvocation() {
        this.agent.exitSelenideContext();
    }

    @Override
    protected PumpoProxy getInvocationHandler() {
        return new MobileProxyInvocationHandler(this, this.core, this.agent);
    }

    void doSelect(Method method, Object[] args) {
        Select annotation = method.getAnnotation(Select.class);
        if (annotation != null) {
            if (args == null) {
                throw new IllegalArgumentException("@Select requires at least one parameter (which should specify either option name or option index)");
            }
            Object untypedArgument = args[args.length - 1];
            String finalSelector = this.processSelector(annotation.value(), args, 1, annotation);
            if (untypedArgument instanceof Integer) {
                Integer optionIndex = (Integer)untypedArgument;
                LOG.debug("{} > @Select for {} by {} for option at index {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), optionIndex});
                this.agent.selectOption(finalSelector, annotation.by(), annotation.timeout(), optionIndex);
            } else {
                String textOrValue = String.valueOf(untypedArgument);
                if (annotation.byText()) {
                    LOG.debug("{} > @Select for {} by {} for option with text {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), textOrValue});
                    this.agent.selectOption(finalSelector, annotation.by(), annotation.timeout(), textOrValue);
                } else {
                    LOG.debug("{} > @Select for {} by {} for option with value {}", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), textOrValue});
                    this.agent.selectOptionByValue(finalSelector, annotation.by(), annotation.timeout(), textOrValue);
                }
            }
        }
    }

    void doClick(Method method, Object[] args) {
        Arrays.stream((Click[])method.getAnnotationsByType(Click.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @Click for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            while (true) {
                try {
                    this.agent.click(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
                    return;
                }
                catch (WebDriverException e) {
                    LOG.debug("{} > @Click failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), retries, pause});
                    WebDriverException lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @Click waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @Click now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries > 0) continue;
                    LOG.warn("{} > @Click ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                    lastException.addSuppressed((Throwable)new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                    throw lastException;
                }
                break;
            }
        });
    }

    void doDoubleClick(Method method, Object[] args) {
        Arrays.stream((DoubleClick[])method.getAnnotationsByType(DoubleClick.class)).forEach(annotation -> {
            String finalSelector = this.processSelector(annotation.value(), args, 0, (Annotation)annotation);
            LOG.debug("{} > @DoubleClick for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            int retries = annotation.retries();
            Duration pause = Duration.ofSeconds(annotation.pause());
            while (true) {
                try {
                    this.agent.doubleClick(finalSelector, annotation.by(), annotation.timeout(), annotation.tryCoordinates());
                    return;
                }
                catch (WebDriverException e) {
                    LOG.debug("{} > @DoubleClick failed with exception thrown {} ({}), retries {}, pause {}", new Object[]{this.getAnnotatedElementShortName(method), e.getMessage(), ((Object)((Object)e)).getClass().getSimpleName(), retries, pause});
                    WebDriverException lastException = e;
                    if (--retries == 0) continue;
                    LOG.trace("{} > @DoubleClick waiting {}s before retrying", (Object)this.getAnnotatedElementShortName(method), (Object)pause);
                    TestUtils.threadSleep(pause.toMillis());
                    LOG.trace("{} > @DoubleClick now retrying", (Object)this.getAnnotatedElementShortName(method));
                    if (retries > 0) continue;
                    LOG.warn("{} > @DoubleClick ran out of retries", (Object)this.getAnnotatedElementShortName(method));
                    lastException.addSuppressed((Throwable)new PumpoException(String.format("Failed after %s retries", annotation.retries())));
                    throw lastException;
                }
                break;
            }
        });
    }

    void doScrollIntoView(Method method, Object[] args) {
        ScrollIntoView annotation = method.getAnnotation(ScrollIntoView.class);
        if (annotation != null) {
            String finalSelector = this.processSelector(annotation.value(), args, 0, annotation);
            LOG.debug("{} > @ScrollIntoView for {} by {} for option with timeout {}s", new Object[]{this.getAnnotatedElementShortName(method), finalSelector, annotation.by(), annotation.timeout()});
            this.agent.scrollIntoView(finalSelector, annotation.by(), annotation.timeout());
        }
    }
}

