/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.mobile;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.PumpoProxy;
import dev.pumpo5.mobile.MobileAgent;
import dev.pumpo5.mobile.MobileAgentAccessor;
import dev.pumpo5.mobile.MobileProxyFactory;
import dev.pumpo5.mobile.MobileSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileProxyInvocationHandler
extends PumpoProxy {
    protected static final Logger LOG = LoggerFactory.getLogger(MobileProxyInvocationHandler.class);
    private final MobileProxyFactory factory;
    private final MobileAgent agent;
    private final MobileSupport mobileSupport;

    public MobileProxyInvocationHandler(MobileProxyFactory factory, CoreAccessor core, MobileAgent agent) {
        super(factory, core);
        this.factory = factory;
        this.agent = agent;
        this.mobileSupport = new MobileSupport(agent);
    }

    @Override
    protected Optional<Object> processAdditionalDelegates(CoreAccessor core, Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (MobileAgentAccessor.class.equals(method.getDeclaringClass())) {
            return Optional.of(method.invoke((Object)this.mobileSupport, args));
        }
        return Optional.empty();
    }

    @Override
    protected void processFocusChangingAnnotations(Method method, Object[] args) {
        this.factory.doScrollIntoView(method, args);
        this.factory.doClick(method, args);
        this.factory.doDoubleClick(method, args);
        this.factory.doSelect(method, args);
    }
}

