/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.mobile;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.InvalidStateException;
import dev.pumpo5.PumpoException;
import dev.pumpo5.Utils;
import dev.pumpo5.config.Config;
import dev.pumpo5.core.Lookup;
import dev.pumpo5.mobile.MobileAgent;
import dev.pumpo5.selenide.AbstractSelenideAgent;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumClientConfig;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.remote.AppiumCommandExecutor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.ClientConfig;

public class RemoteMobileAgent
extends AbstractSelenideAgent
implements MobileAgent {
    private static final String CANNOT_CREATE_WEB_DRIVER = "Cannot create Web Driver";
    private String globalLookupPrefix;
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(10L);

    public RemoteMobileAgent(Map<String, Object> capabilities, String farmUrl, Config config) {
        super(capabilities, farmUrl, config);
    }

    protected AppiumDriver initDriver(Map<String, Object> capabilities, String farmUrl, Config config) {
        try {
            if (!capabilities.containsKey("pn5:mobile:platform")) {
                throw new IllegalStateException("You need to set pn5:mobile:platform capability to one of the supported mobile platform types (pn5:mobile:android,pn5:mobile:ios");
            }
            String platform = (String)capabilities.get("pn5:mobile:platform");
            if (platform == null) {
                throw new IllegalStateException(String.format("Mobile platform cannot be null. You need to select ether %s or %s", "pn5:mobile:android", "pn5:mobile:ios"));
            }
            AppiumClientConfig clientConfig = AppiumClientConfig.defaultConfig().baseUrl(new URL(farmUrl)).readTimeout(DEFAULT_READ_TIMEOUT);
            if (config.containsKey("pn5.appium.proxy.host") && config.containsKey("pn5.appium.proxy.host")) {
                clientConfig = AppiumClientConfig.fromClientConfig((ClientConfig)clientConfig.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.get("pn5.appium.proxy.host"), Integer.parseInt(config.get("pn5.appium.proxy.port"))))));
            }
            switch (platform) {
                case "pn5:mobile:android": {
                    AndroidDriver androidDriver = new AndroidDriver((HttpCommandExecutor)new AppiumCommandExecutor(MobileCommand.commandRepository, clientConfig), (Capabilities)new MutableCapabilities(capabilities));
                    this.globalLookupPrefix = (String)capabilities.get("pn5:idPrefix");
                    return androidDriver;
                }
                case "pn5:mobile:ios": {
                    return new IOSDriver((HttpCommandExecutor)new AppiumCommandExecutor(MobileCommand.commandRepository, clientConfig), (Capabilities)new MutableCapabilities(capabilities));
                }
            }
            throw new IllegalStateException(String.format("Mobile platform '%s' is not supported. You need to select ether %s or %s", platform, "pn5:mobile:android", "pn5:mobile:ios"));
        }
        catch (Throwable e) {
            throw new IllegalStateException(CANNOT_CREATE_WEB_DRIVER, e);
        }
    }

    public AppiumDriver getDriver() {
        return (AppiumDriver)this.selenideDriver.getWebDriver();
    }

    @Override
    public String getText(String selector, Lookup type, int timeout) {
        return this.getElement(selector, type, timeout).getText();
    }

    @Override
    public String getAttribute(String selector, Lookup type, String attributeName, int timeout) {
        String returnValue = this.getElement(selector, type, timeout).getAttribute(attributeName);
        return returnValue == null ? "" : returnValue;
    }

    @Override
    public void setValue(String selector, Lookup type, String value, int timeout, boolean byTyping) {
        SelenideElement element = this.getElement(selector, type, timeout);
        element.scrollIntoView(true);
        if (!byTyping) {
            element.setValue(value);
        } else {
            try {
                element.clear();
                TimeUnit.MILLISECONDS.sleep(200L);
                element.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                element.sendKeys(new CharSequence[]{Keys.DELETE});
                TimeUnit.MILLISECONDS.sleep(200L);
                element.setValue("");
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException ex) {
                throw new PumpoException("Error trying to set value on element:", ex);
            }
            element.sendKeys(new CharSequence[]{value});
        }
    }

    private void tryDoubleClickUntilTimeout(SelenideElement element, long endTime, boolean tryCoordinates) {
        while (true) {
            try {
                element.doubleClick();
                break;
            }
            catch (InvalidStateException | InvalidElementStateException e) {
                if (endTime > System.currentTimeMillis()) {
                    if (tryCoordinates) {
                        Actions actions = new Actions(this.selenideDriver.getWebDriver());
                        actions.moveToElement((WebElement)element, element.getRect().width / 2, element.getRect().height / 2).doubleClick();
                        break;
                    }
                    throw e;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new PumpoException("Error trying to double click on element:", e1);
                }
            }
        }
    }

    @Override
    public void selectOption(String selector, Lookup type, int timeout, int ... indexes) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (indexes.length == 1) {
            element.selectOption(indexes[0], new int[0]);
        } else {
            element.selectOption(indexes[0], Arrays.copyOfRange(indexes, 1, indexes.length));
        }
    }

    @Override
    public void selectOption(String selector, Lookup type, int timeout, String ... texts) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (texts.length == 1) {
            element.selectOption(texts[0], new String[0]);
        } else {
            element.selectOption(texts[0], Arrays.copyOfRange(texts, 1, texts.length));
        }
    }

    @Override
    public void selectOptionByValue(String selector, Lookup type, int timeout, String ... values) {
        SelenideElement element = this.getElement(selector, type, timeout);
        if (values.length == 1) {
            element.selectOption(values[0], new String[0]);
        } else {
            element.selectOptionByValue(values[0], Arrays.copyOfRange(values, 1, values.length));
        }
    }

    @Override
    public SelenideElement getElement(String selector, Lookup type, int timeout) {
        if (this.globalLookupPrefix != null && (type == Lookup.ID || type == Lookup.DEFAULT) && this.selenideDriver.getWebDriver() instanceof AndroidDriver) {
            selector = this.globalLookupPrefix + (String)selector;
        }
        return this.selenideDriver.$(this.translateLookup(type).apply((String)selector)).shouldBe(Condition.visible, Duration.ofSeconds(timeout));
    }

    public String getReportsFolder() {
        return this.selenideDriver.config().reportsFolder();
    }

    public boolean isReportsFolderEnabled() {
        return this.selenideDriver.config().screenshots() && this.selenideDriver.config().savePageSource();
    }

    @Override
    public Function<String, By> translateLookup(Lookup lookup) {
        lookup = Utils.getDefaultLookupValue(((RemoteWebDriver)this.selenideDriver.getWebDriver()).getCapabilities(), lookup);
        switch (lookup) {
            case CLASS_NAME: {
                return AppiumBy::className;
            }
            case XPATH: {
                return By::xpath;
            }
            case ACCESSIBILITY_ID: {
                return AppiumBy::accessibilityId;
            }
            case ID: 
            case DEFAULT: {
                return AppiumBy::id;
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support Lookup '%s' for mobile applications", lookup.name()));
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException("We do not support getUrl() for mobile applications");
    }
}

