/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import dev.pumpo5.config.Config;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.http.HttpAgent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpAgentSupport
extends AbstractRemoteDriverAgent
implements HttpAgent {
    private static final String FETCH = "http_fetch";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>(){
        {
            this.put(HttpAgentSupport.FETCH, new CommandInfo("/session/:sessionId/pn5-http/fetch", HttpMethod.POST));
        }
    };

    public HttpAgentSupport(Logger logger, Config config, Map<String, Object> capabilities, String farmUrl) {
        super(logger, config, capabilities, farmUrl);
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    public Response getWebDriverResponse(String url, String method, Map<String, String> headers, String httpAuthentication, String authUsername, String authPassword, String authToken, String authDomain, String authWorkstation, String certificate, String key, String payload, boolean payloadIsBinary, int remoteTimeout) {
        Response webDriverResponse;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", url);
        map.put("method", method);
        map.put("headers", headers);
        map.put("httpAuthentication", httpAuthentication);
        map.put("authUsername", authUsername);
        map.put("authPassword", authPassword);
        map.put("authToken", authToken);
        map.put("authDomain", authDomain);
        map.put("authWorkstation", authWorkstation);
        map.put("certificate", certificate);
        map.put("key", key);
        map.put("remoteTimeout", remoteTimeout);
        if (payload != null) {
            map.put("payload", payload);
            map.put("payloadIsBinary", payloadIsBinary);
        }
        try {
            webDriverResponse = this.driver.execute(FETCH, map);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while requesting remote http agent to process request to url " + url + " with method " + method + ", exception thrown by the WebDriver library is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (webDriverResponse == null) {
            throw new RuntimeException("Null value returned while requesting remote http agent to process request to url " + url + " with method " + method + ", we do not have additional details");
        }
        return webDriverResponse;
    }
}

