/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.DurationStyle;
import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.http.HttpAgent;
import dev.pumpo5.remote.http.HttpAgentSupport;
import dev.pumpo5.remote.http.HttpApplication;
import dev.pumpo5.remote.http.HttpRequestBuilder;
import dev.pumpo5.remote.http.HttpResponse;
import dev.pumpo5.remote.http.RestRequestBuilder;
import dev.pumpo5.remote.http.SoapRequestBuilder;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.remote.Response;

public class HttpApplicationSupport
extends ApplicationSupport<HttpApplication>
implements HttpApplication,
SessionManager<HttpApplication> {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    protected HttpAgentSupport agent;

    public HttpApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public HttpAgentSupport newAgent() {
        return new HttpAgentSupport(this.getLogger(), this.getConfig(), this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public HttpRequestBuilder prepareHttpRequest(String url, String method) {
        return new HttpRequestBuilder(this, url, method);
    }

    @Override
    public RestRequestBuilder prepareRestRequest(String url, String method) {
        return new RestRequestBuilder(this, url, method);
    }

    @Override
    public SoapRequestBuilder prepareSoapRequest(String url) {
        return new SoapRequestBuilder(this, url);
    }

    <T extends HttpResponse> T sendRequest(String url, String method, Map<String, String> headers, String httpAuthentication, String authUsername, String authPassword, String authToken, String authDomain, String authWorkstation, String certificate, String key, String payload, boolean payloadIsBinary, Class<T> tClass) {
        HttpResponse specificResponse;
        this.checkSessionStarted();
        Response webDriverResponse = this.agent.getWebDriverResponse(url, method, headers, httpAuthentication, authUsername, authPassword, authToken, authDomain, authWorkstation, certificate, key, payload, payloadIsBinary, this.getRemoteTimeout());
        try {
            specificResponse = (HttpResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(webDriverResponse.getValue()), tClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while parsing the response received by the the remote http agent after sending a request to url " + url + " with method " + method + ", exception thrown by our response parser is: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (specificResponse == null) {
            throw new RuntimeException("Null value returned by our parser when parsing the http response received by the remote http agent when after sending a request to url " + url + " with method " + method + ", the raw WebDriverResponse was: " + webDriverResponse);
        }
        specificResponse.initialRequest = new HttpResponse.InitialHttpRequest(url, method, headers, payload);
        specificResponse.setHttpApplication(this);
        return (T)specificResponse;
    }

    private int getRemoteTimeout() {
        int sessionTimeout;
        int remoteTimeout;
        try {
            remoteTimeout = this.capabilities.getOrDefault("pn5:remoteTimeout", 70);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while reading value for 'pn5:remoteTimeout' capability: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        try {
            String sessionTimeoutStr = ((Map)this.capabilities.get("selenoid:options")).get("sessionTimeout").toString();
            sessionTimeout = Arrays.stream(sessionTimeoutStr.split("((?<=[dhms]))")).reduce(0, (subtotal, element) -> (int)((long)subtotal.intValue() + DurationStyle.detectAndParse(element).getSeconds()), Integer::sum);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while parsing value for sessionTimeout capability: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (sessionTimeout < remoteTimeout) {
            throw new IllegalArgumentException("Value of sessionTimeout capability is less than the value for 'pn5:remoteTimeout' capability (" + sessionTimeout + "s < " + remoteTimeout + "s). Use a value greater than or equal to 'pn5:remoteTimeout'.");
        }
        return remoteTimeout;
    }

    public static <APPLICATION_OBJECT extends HttpApplication> APPLICATION_OBJECT createProxy(Class<? extends HttpApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!HttpApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend HttpApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((HttpApplication)Proxy.newProxyInstance(HttpAgent.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<HttpApplicationSupport>(type, new HttpApplicationSupport(core, driverUrl, capabilities))));
    }
}

