/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import dev.pumpo5.remote.http.HttpApplicationSupport;
import dev.pumpo5.remote.http.HttpResponse;
import dev.pumpo5.remote.http.HttpUtils;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HttpRequestBuilder {
    protected final HttpApplicationSupport httpApplicationSupport;
    protected String url;
    protected final String method;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected final Map<String, String> cookies = new HashMap<String, String>();
    protected String httpAuthentication;
    protected String authUsername;
    protected String authPassword;
    protected String authToken;
    protected String authDomain;
    protected String authWorkstation;
    protected String certificate;
    protected String key;
    protected final Map<String, String> queryParams = new HashMap<String, String>();
    protected String payload;
    protected boolean payloadIsBinary = false;
    private static final String PKCS1_HEADER = "BEGIN RSA PRIVATE KEY";
    private static final String PKCS8_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String CERTIFICATE_HEADER = "BEGIN CERTIFICATE";

    public HttpRequestBuilder(HttpApplicationSupport httpApplicationSupport, String url, String method) {
        this.httpApplicationSupport = httpApplicationSupport;
        this.url = url;
        this.method = method;
    }

    public HttpRequestBuilder replaceInUrl(String placeholder, String value) {
        this.url = this.url.replace(placeholder, value);
        return this;
    }

    public HttpRequestBuilder withQueryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public HttpRequestBuilder withHeader(String key, String ... values) {
        this.headers.put(key, String.join((CharSequence)",", values));
        return this;
    }

    public HttpRequestBuilder withCookie(String name, String value) {
        String encodedValue = ClientCookieEncoder.LAX.encode(name, value);
        this.cookies.put(name, encodedValue);
        return this;
    }

    public HttpRequestBuilder withBasicAuth(String user, String password) {
        this.httpAuthentication = "basic";
        this.authUsername = user;
        this.authPassword = password;
        return this;
    }

    public HttpRequestBuilder withBearerAuth(String token) {
        this.httpAuthentication = "bearer";
        this.authToken = token;
        return this;
    }

    public HttpRequestBuilder withBearerAuthResolved(String oAuthEndpoint, String clientId, String clientSecret, String scope) {
        return this.withBearerAuth(HttpUtils.obtainAuthorizationToken(this.httpApplicationSupport, oAuthEndpoint, clientId, clientSecret, scope));
    }

    public HttpRequestBuilder withBearerAuthResolved(String oAuthEndpoint, String clientId, String clientSecret, String scope, String userName, String userPassword) {
        return this.withBearerAuth(HttpUtils.obtainAuthorizationToken(this.httpApplicationSupport, oAuthEndpoint, clientId, clientSecret, scope, userName, userPassword));
    }

    public HttpRequestBuilder withNtlmAuth(String domain, String username, String password, String workstation) {
        this.httpAuthentication = "ntlm";
        this.authUsername = username;
        this.authPassword = password;
        this.authDomain = domain;
        this.authWorkstation = workstation;
        return this;
    }

    public HttpRequestBuilder withClientCertAuth(String certificate, String key) {
        this.certificate = certificate.contains(CERTIFICATE_HEADER) ? certificate : this.readFile(certificate);
        this.key = key.contains(PKCS1_HEADER) || key.contains(PKCS8_HEADER) ? key : this.readFile(key);
        this.httpAuthentication = "client-certificate";
        return this;
    }

    public HttpRequestBuilder withPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public HttpRequestBuilder withBinaryPayload(byte[] payload) {
        this.payload = Base64.getEncoder().encodeToString(payload);
        this.payloadIsBinary = true;
        return this;
    }

    public HttpRequestBuilder withPayloadFromFile(String path) {
        try {
            URL resourceUrl = this.getClass().getClassLoader().getResource(path);
            if (resourceUrl == null) {
                throw new IllegalArgumentException("Did not find file on classpath: " + path);
            }
            this.payload = Files.readString(Path.of(resourceUrl.toURI()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read payload file " + path + ": " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return this;
    }

    public HttpRequestBuilder withBinaryPayloadFromFile(String path) {
        try {
            URL resourceUrl = this.getClass().getClassLoader().getResource(path);
            if (resourceUrl == null) {
                throw new IllegalArgumentException("Did not find file on classpath: " + path);
            }
            this.payload = Base64.getEncoder().encodeToString(Files.readAllBytes(Path.of(resourceUrl.toURI())));
            this.payloadIsBinary = true;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read payload file " + path + ": " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return this;
    }

    public HttpRequestBuilder replaceInPayload(String placeholder, String value) {
        if (this.payload == null) {
            throw new IllegalStateException("Payload has not yet been set");
        }
        this.payload = this.payload.replace(placeholder, value);
        return this;
    }

    public HttpResponse sendAndGetResponse() {
        String enrichedUrl = HttpUtils.enrichUrl(this.url, this.queryParams);
        return this.httpApplicationSupport.sendRequest(enrichedUrl, this.method, this.getAllHeaders(), this.httpAuthentication, this.authUsername, this.authPassword, this.authToken, this.authDomain, this.authWorkstation, this.certificate, this.key, this.payload, this.payloadIsBinary, HttpResponse.class);
    }

    protected Map<String, String> getAllHeaders() {
        if (!this.cookies.isEmpty()) {
            if (this.headers.containsKey("Cookie")) {
                throw new IllegalStateException("Header Cookie is already set (directly as header), but cookies are also set. Cannot combine both approaches");
            }
            String cookies = String.join((CharSequence)"; ", this.cookies.values());
            this.headers.put("Cookie", cookies);
        }
        return this.headers;
    }

    private String readFile(String filePath) {
        String fileContent;
        try {
            URL certificateUrl = this.getClass().getClassLoader().getResource(filePath);
            if (certificateUrl == null) {
                throw new IllegalArgumentException("Did not find file on classpath: " + filePath);
            }
            fileContent = Files.readString(Path.of(certificateUrl.toURI()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read certificate file " + filePath + ": " + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return fileContent;
    }
}

