/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.remote.http.HttpApplication;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

public class HttpResponse {
    protected static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public int status;
    public Map<String, String> headers;
    public String payload;
    public InitialHttpRequest initialRequest;
    protected HttpApplication httpApplication;

    void setHttpApplication(HttpApplication HttpApplication2) {
        this.httpApplication = HttpApplication2;
    }

    public HttpResponse printRequest() {
        if (this.initialRequest == null) {
            System.out.println("Initial request seems to be null");
        } else {
            System.out.println("$$$$ Initial request sent by the http driver to the target host was:");
            System.out.println("$$ HTTP Url: " + this.initialRequest.url);
            System.out.println("$$ HTTP Method: " + this.initialRequest.method);
            System.out.println("$$ HTTP Headers:");
            this.initialRequest.headers.forEach((name, value) -> System.out.println(name + ": " + value));
            if (!this.initialRequest.headers.containsKey("Host")) {
                System.out.println("$$ Note: The 'Host' header was not set so the driver automatically added it matching the host from the url (to comply with HTTP 1.1)");
            }
            System.out.println("$$ Note: No authentication headers are reproduced here, they were added by the driver if requested");
            System.out.println("$$ HTTP Payload:");
            System.out.println(this.initialRequest.payload);
        }
        return this;
    }

    public HttpResponse printResponse() {
        System.out.println("### Response from the the target host obtained by the http driver was:");
        System.out.println("## HTTP Status: " + this.status);
        System.out.println("## HTTP Headers:");
        this.headers.forEach((name, value) -> System.out.println(name + ": " + value));
        System.out.println("## HTTP Payload:");
        System.out.println(this.payload);
        return this;
    }

    public HttpResponse assertStatus(int status) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.status).as("HTTP Response status code", new Object[0])).isEqualTo(status);
        return this;
    }

    public HttpResponse assertBodyIsNotEmpty() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.payload).as("HTTP Response body is not empty", new Object[0])).isNotEmpty();
        return this;
    }

    public HttpResponse assertPayloadContains(String needle) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.payload).as("HTTP Response body contains the specified needle", new Object[0])).contains(new CharSequence[]{needle});
        return this;
    }

    public HttpResponse assertHeaderReceived(String headerName) {
        ((MapAssert)Assertions.assertThat(this.headers).as("HTTP Response headers contain the specified key at least once", new Object[0])).containsKey((Object)headerName);
        return this;
    }

    public HttpResponse assertHeaderContains(String headerName, String value) {
        this.assertHeaderReceived(headerName);
        ((AbstractStringAssert)Assertions.assertThat((String)this.headers.get(headerName)).as("HTTP Response header with specified key contains the specified needle", new Object[0])).contains(new CharSequence[]{value});
        return this;
    }

    public HttpApplication andThen() {
        return this.httpApplication;
    }

    static class InitialHttpRequest {
        public String url;
        public String method;
        public Map<String, String> headers;
        public String payload;

        public InitialHttpRequest(String url, String method, Map<String, String> headers, String payload) {
            this.url = url;
            this.method = method;
            this.headers = headers;
            this.payload = payload;
        }
    }
}

