/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.pumpo5.remote.http.HttpApplicationSupport;
import java.lang.invoke.StringConcatFactory;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class HttpUtils {
    public static String enrichUrl(String url, Map<String, String> queryParams) {
        if (queryParams == null || queryParams.isEmpty()) {
            return url;
        }
        String queryToAppend = HttpUtils.urlEncodeParams(queryParams);
        if (!url.contains("?")) {
            return url + "?" + queryToAppend;
        }
        if (url.endsWith("?")) {
            return url + queryToAppend;
        }
        if (!url.contains("&")) {
            return url + "&" + queryToAppend;
        }
        if (url.endsWith("&")) {
            return url + queryToAppend;
        }
        return url + "&" + queryToAppend;
    }

    static String urlEncodeUTF8(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    public static String urlEncodeParams(Map<String, String> params) {
        return params.entrySet().stream().map(p -> HttpUtils.urlEncodeUTF8((String)p.getKey()) + "=" + HttpUtils.urlEncodeUTF8((String)p.getValue())).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
    }

    public static String obtainAuthorizationToken(HttpApplicationSupport httpApplicationSupport, String identityServiceUrl, String identityName, String identityPassword, String scope) {
        return httpApplicationSupport.prepareRestRequest((String)identityServiceUrl, (String)"POST").withBasicAuth((String)identityName, (String)identityPassword).withHeader((String)"Content-Type", (String[])new String[]{"application/x-www-form-urlencoded"}).withPayload((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"grant_type=client_credentials&scope=\u0001"}, (String)HttpUtils.urlEncodeUTF8((String)scope)))).sendAndGetResponse().assertStatus((int)200).payloadAs(AccessTokenResponse.class).accessToken;
    }

    public static String obtainAuthorizationToken(HttpApplicationSupport httpApplicationSupport, String identityServiceUrl, String identityName, String identityPassword, String scope, String userName, String userPassword) {
        return httpApplicationSupport.prepareRestRequest((String)identityServiceUrl, (String)"POST").withBasicAuth((String)identityName, (String)identityPassword).withHeader((String)"Content-Type", (String[])new String[]{"application/x-www-form-urlencoded"}).withPayload((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"grant_type=password&client_id=\u0001&client_secret=\u0001&username=\u0001&password=\u0001&scope=\u0001"}, (String)identityName, (String)HttpUtils.urlEncodeUTF8((String)identityPassword), (String)HttpUtils.urlEncodeUTF8((String)userName), (String)HttpUtils.urlEncodeUTF8((String)userPassword), (String)HttpUtils.urlEncodeUTF8((String)scope)))).sendAndGetResponse().assertStatus((int)200).payloadAs(AccessTokenResponse.class).accessToken;
    }

    static class AccessTokenResponse {
        @JsonProperty(value="access_token")
        private String accessToken;

        AccessTokenResponse() {
        }
    }
}

