/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import dev.pumpo5.remote.http.HttpApplicationSupport;
import dev.pumpo5.remote.http.HttpRequestBuilder;
import dev.pumpo5.remote.http.HttpUtils;
import dev.pumpo5.remote.http.RestResponse;

public class RestRequestBuilder
extends HttpRequestBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JodaModule());

    public RestRequestBuilder(HttpApplicationSupport httpApplication, String url, String method) {
        super(httpApplication, url, method);
    }

    @Override
    public RestRequestBuilder replaceInUrl(String placeholder, String value) {
        return (RestRequestBuilder)super.replaceInUrl(placeholder, value);
    }

    @Override
    public RestRequestBuilder withQueryParam(String key, String value) {
        return (RestRequestBuilder)super.withQueryParam(key, value);
    }

    @Override
    public RestRequestBuilder withHeader(String key, String ... values) {
        return (RestRequestBuilder)super.withHeader(key, values);
    }

    @Override
    public RestRequestBuilder withBasicAuth(String user, String password) {
        return (RestRequestBuilder)super.withBasicAuth(user, password);
    }

    @Override
    public RestRequestBuilder withBearerAuth(String token) {
        return (RestRequestBuilder)super.withBearerAuth(token);
    }

    @Override
    public RestRequestBuilder withBearerAuthResolved(String oAuthEndpoint, String clientId, String clientSecret, String scope) {
        return (RestRequestBuilder)super.withBearerAuthResolved(oAuthEndpoint, clientId, clientSecret, scope);
    }

    @Override
    public RestRequestBuilder withBearerAuthResolved(String oAuthEndpoint, String clientId, String clientSecret, String scope, String userName, String userPassword) {
        return (RestRequestBuilder)super.withBearerAuthResolved(oAuthEndpoint, clientId, clientSecret, scope, userName, userPassword);
    }

    @Override
    public RestRequestBuilder withNtlmAuth(String domain, String username, String password, String workstation) {
        return (RestRequestBuilder)super.withNtlmAuth(domain, username, password, workstation);
    }

    @Override
    public RestRequestBuilder withClientCertAuth(String certificate, String key) {
        return (RestRequestBuilder)super.withClientCertAuth(certificate, key);
    }

    @Override
    public RestRequestBuilder withPayload(String payload) {
        return (RestRequestBuilder)super.withPayload(payload);
    }

    @Override
    public RestRequestBuilder withBinaryPayload(byte[] payload) {
        return (RestRequestBuilder)super.withBinaryPayload(payload);
    }

    @Override
    public RestRequestBuilder withPayloadFromFile(String path) {
        return (RestRequestBuilder)super.withPayloadFromFile(path);
    }

    @Override
    public RestRequestBuilder withBinaryPayloadFromFile(String path) {
        return (RestRequestBuilder)super.withBinaryPayloadFromFile(path);
    }

    @Override
    public RestRequestBuilder replaceInPayload(String placeholder, String value) {
        return (RestRequestBuilder)super.replaceInPayload(placeholder, value);
    }

    public RestRequestBuilder withJsonFromPojoPayload(Object payload) {
        try {
            this.payload = MAPPER.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize payload to JSON", e);
        }
        return this;
    }

    @Override
    public RestResponse sendAndGetResponse() {
        String enrichedUrl = HttpUtils.enrichUrl(this.url, this.queryParams);
        return this.httpApplicationSupport.sendRequest(enrichedUrl, this.method, this.getAllHeaders(), this.httpAuthentication, this.authUsername, this.authPassword, this.authToken, this.authDomain, this.authWorkstation, this.certificate, this.key, this.payload, this.payloadIsBinary, RestResponse.class);
    }
}

