/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import dev.pumpo5.remote.http.HttpApplicationSupport;
import dev.pumpo5.remote.http.HttpRequestBuilder;
import dev.pumpo5.remote.http.HttpUtils;
import dev.pumpo5.remote.http.SoapResponse;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class SoapRequestBuilder
extends HttpRequestBuilder {
    private static final XmlMapper MAPPER = new XmlMapper();

    public SoapRequestBuilder(HttpApplicationSupport httpApplicationSupport, String url) {
        super(httpApplicationSupport, url, "POST");
    }

    @Override
    public SoapRequestBuilder replaceInUrl(String placeholder, String value) {
        return (SoapRequestBuilder)super.replaceInUrl(placeholder, value);
    }

    @Override
    public SoapRequestBuilder withQueryParam(String key, String value) {
        return (SoapRequestBuilder)super.withQueryParam(key, value);
    }

    @Override
    public SoapRequestBuilder withHeader(String key, String ... values) {
        return (SoapRequestBuilder)super.withHeader(key, values);
    }

    @Override
    public SoapRequestBuilder withBasicAuth(String user, String password) {
        return (SoapRequestBuilder)super.withBasicAuth(user, password);
    }

    @Override
    public SoapRequestBuilder withBearerAuth(String token) {
        return (SoapRequestBuilder)super.withBearerAuth(token);
    }

    @Override
    public SoapRequestBuilder withBearerAuthResolved(String identityServiceUrl, String clientId, String clientSecret, String scope) {
        return (SoapRequestBuilder)super.withBearerAuthResolved(identityServiceUrl, clientId, clientSecret, scope);
    }

    @Override
    public SoapRequestBuilder withBearerAuthResolved(String oAuthEndpoint, String clientId, String clientSecret, String scope, String userName, String userPassword) {
        return (SoapRequestBuilder)super.withBearerAuthResolved(oAuthEndpoint, clientId, clientSecret, scope, userName, userPassword);
    }

    @Override
    public SoapRequestBuilder withNtlmAuth(String domain, String username, String password, String workstation) {
        return (SoapRequestBuilder)super.withNtlmAuth(domain, username, password, workstation);
    }

    @Override
    public SoapRequestBuilder withClientCertAuth(String certificate, String key) {
        return (SoapRequestBuilder)super.withClientCertAuth(certificate, key);
    }

    @Override
    public SoapRequestBuilder withPayload(String payload) {
        return (SoapRequestBuilder)super.withPayload(payload);
    }

    @Override
    public SoapRequestBuilder withPayloadFromFile(String path) {
        return (SoapRequestBuilder)super.withPayloadFromFile(path);
    }

    @Override
    public SoapRequestBuilder replaceInPayload(String placeholder, String value) {
        return (SoapRequestBuilder)super.replaceInPayload(placeholder, value);
    }

    public SoapRequestBuilder withAction(String soapAction) {
        this.headers.put("SOAPAction", soapAction);
        return this;
    }

    public SoapRequestBuilder withXmlFromPojoPayload(Object payload) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{payload.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal(payload, (Writer)writer);
            this.payload = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body>\n" + writer + "\n</soap:Body>\n</soap:Envelope>";
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    protected Map<String, String> getAllHeaders() {
        Map<String, String> allHeaders = super.getAllHeaders();
        if (!this.headers.containsKey("Content-Type")) {
            this.headers.put("Content-Type", "text/xml; charset=utf-8");
        }
        return allHeaders;
    }

    @Override
    public SoapResponse sendAndGetResponse() {
        String enrichedUrl = HttpUtils.enrichUrl(this.url, this.queryParams);
        return this.httpApplicationSupport.sendRequest(enrichedUrl, this.method, this.getAllHeaders(), this.httpAuthentication, this.authUsername, this.authPassword, this.authToken, this.authDomain, this.authWorkstation, this.certificate, this.key, this.payload, this.payloadIsBinary, SoapResponse.class);
    }
}

