/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.remote.http.HttpResponse;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapResponse
extends HttpResponse {
    private static final XmlMapper MAPPER = (XmlMapper)new XmlMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    public SoapResponse printRequest() {
        return (SoapResponse)super.printRequest();
    }

    @Override
    public SoapResponse printResponse() {
        super.printResponse();
        return this;
    }

    @Override
    public SoapResponse assertStatus(int status) {
        return (SoapResponse)super.assertStatus(status);
    }

    @Override
    public SoapResponse assertBodyIsNotEmpty() {
        return (SoapResponse)super.assertBodyIsNotEmpty();
    }

    @Override
    public SoapResponse assertPayloadContains(String needle) {
        return (SoapResponse)super.assertPayloadContains(needle);
    }

    @Override
    public SoapResponse assertHeaderReceived(String headerName) {
        return (SoapResponse)super.assertHeaderReceived(headerName);
    }

    @Override
    public SoapResponse assertHeaderContains(String headerName, String value) {
        return (SoapResponse)super.assertHeaderContains(headerName, value);
    }

    public <PoJoClass> PoJoClass payloadAs(Class<PoJoClass> poJoClass) {
        return (PoJoClass)Optional.ofNullable(this.payload).map(body -> {
            try {
                return MAPPER.readTree(body);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }).map(root -> root.path("Body")).filter(body -> body.elements().hasNext()).map(body -> (JsonNode)body.elements().next()).map(response -> MAPPER.convertValue(response, poJoClass)).orElseThrow(() -> new IllegalStateException(String.format("Failed to map response '%s' onto %s", this.payload, poJoClass.getSimpleName())));
    }

    public <PoJoClass> PoJoClass payloadXmlAs(Class<PoJoClass> poJoClass) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new ByteArrayInputStream(this.payload.getBytes(StandardCharsets.UTF_8)));
            Node soapBody = document.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
            if (soapBody != null && soapBody.hasChildNodes()) {
                NodeList children = soapBody.getChildNodes();
                Node responseNode = null;
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    responseNode = node;
                    break;
                }
                if (responseNode == null) {
                    throw new IllegalStateException("No suitable child element found in SOAP Body");
                }
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{poJoClass});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                return poJoClass.cast(unmarshaller.unmarshal(responseNode));
            }
            throw new IllegalStateException("SOAP Body is empty or not found");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unmarshal payload", e);
        }
    }

    public <PoJoClass> ObjectAssert<PoJoClass> assertThatPayload(Class<PoJoClass> poJoClass) {
        return Assertions.assertThat(this.payloadAs(poJoClass));
    }
}

