/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.jamulator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.jamulator.JamulatorAgent;
import dev.pumpo5.remote.jamulator.JamulatorController;
import dev.pumpo5.remote.jamulator.JamulatorEditResponse;
import dev.pumpo5.remote.jamulator.JamulatorRule;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class JamulatorAgentSupport
extends AbstractRemoteDriverAgent
implements JamulatorAgent {
    private static final String ADD = "jamulator_add";
    private static final String DELETE = "jamulator_delete";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();
    private static final ObjectMapper MAPPER;
    JamulatorController jamulatorController;

    public JamulatorAgentSupport(JamulatorController jamulatorController, Map<String, Object> capabilities, String farmUrl) {
        super(jamulatorController.getLogger(), jamulatorController.getConfig(), capabilities, farmUrl);
        this.jamulatorController = jamulatorController;
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    private <T> T parseResponse(Response response, Class<T> clazz) {
        if (response == null) {
            throw new IllegalStateException("Failed to get a valid response from the remote driver");
        }
        try {
            Object parsedResponse = MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), clazz);
            if (parsedResponse == null) {
                parsedResponse = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)parsedResponse;
        }
        catch (JsonProcessingException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public JamulatorEditResponse createRule(JamulatorRule rule, boolean replaceIfExists) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rule", rule);
        map.put("replaceIfExists", replaceIfExists);
        Response response = this.driver.execute(ADD, map);
        return this.parseResponse(response, JamulatorEditResponse.class);
    }

    public JamulatorEditResponse deleteRule(String ruleName, boolean ignoreMissing) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleName", ruleName);
        map.put("ignoreMissing", ignoreMissing);
        Response response = this.driver.execute(DELETE, map);
        return this.parseResponse(response, JamulatorEditResponse.class);
    }

    static {
        ADDITIONAL_COMMANDS.put(ADD, new CommandInfo("/session/:sessionId/pn5-jamulator/addRule", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(DELETE, new CommandInfo("/session/:sessionId/pn5-jamulator/deleteRule", HttpMethod.POST));
        MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

