/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.jamulator;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.jamulator.JamulatorAgentSupport;
import dev.pumpo5.remote.jamulator.JamulatorController;
import dev.pumpo5.remote.jamulator.JamulatorEditResponse;
import dev.pumpo5.remote.jamulator.JamulatorRule;
import dev.pumpo5.remote.jamulator.JamulatorRuleBuilder;
import java.lang.reflect.Proxy;
import java.util.Map;

public class JamulatorControllerSupport
extends ApplicationSupport<JamulatorController>
implements JamulatorController {
    protected JamulatorAgentSupport agent;

    public JamulatorControllerSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends JamulatorController> APPLICATION_OBJECT createProxy(Class<? extends JamulatorController> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!JamulatorController.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend JamulatorController", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((JamulatorController)Proxy.newProxyInstance(JamulatorAgentSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<JamulatorControllerSupport>(type, new JamulatorControllerSupport(core, driverUrl, capabilities))));
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public JamulatorAgentSupport newAgent() {
        return new JamulatorAgentSupport(this, this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public JamulatorRuleBuilder createNewRule() {
        return new JamulatorRuleBuilder(this);
    }

    @Override
    public JamulatorEditResponse deleteRule(String ruleName, boolean ignoreMissing) {
        this.checkSessionStarted();
        this.getLogger().log("Deleting rule " + ruleName, new Object[0]);
        JamulatorEditResponse jamulatorEditResponse = this.agent.deleteRule(ruleName, ignoreMissing);
        if (!jamulatorEditResponse.success()) {
            throw new RuntimeException("Could not delete the rule to Jamulator with reason received: " + jamulatorEditResponse.message());
        }
        this.getLogger().log("Rule " + ruleName + " successfully deleted", new Object[0]);
        return jamulatorEditResponse;
    }

    public JamulatorController addRule(JamulatorRule rule, boolean replaceIfExists) {
        this.checkSessionStarted();
        rule.validate();
        this.getLogger().log("Adding rule " + rule.getName() + " to Jamulator", new Object[0]);
        JamulatorEditResponse jamulatorEditResponse = this.agent.createRule(rule, replaceIfExists);
        if (!jamulatorEditResponse.success()) {
            throw new RuntimeException("Could not add the rule to Jamulator with reason received: " + jamulatorEditResponse.message());
        }
        this.getLogger().log("Rule " + rule.getName() + " successfully added", new Object[0]);
        return this;
    }
}

