/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.jamulator;

import java.util.HashMap;

public class JamulatorRule {
    private String name;
    private long validUntil;
    private int executionCount;
    private String whenFunction;
    private String doFunction;
    private String initFunction;
    private String finaliseFunction;
    private HashMap<String, String> resources = new HashMap();

    public String getName() {
        return this.name;
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public String getWhenFunction() {
        return this.whenFunction;
    }

    public String getDoFunction() {
        return this.doFunction;
    }

    public String getInitFunction() {
        return this.initFunction;
    }

    public String getFinaliseFunction() {
        return this.finaliseFunction;
    }

    public HashMap<String, String> getResources() {
        return this.resources;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public void setExecutionCount(int timeToLive) {
        this.executionCount = timeToLive;
    }

    public void setWhenFunction(String whenFunction) {
        this.whenFunction = whenFunction;
    }

    public void setDoFunction(String doFunction) {
        this.doFunction = doFunction;
    }

    public void setInitFunction(String initFunction) {
        this.initFunction = initFunction;
    }

    public void setFinaliseFunction(String finaliseFunction) {
        this.finaliseFunction = finaliseFunction;
    }

    public void setResources(HashMap<String, String> resources) {
        this.resources = resources;
    }

    void validate() {
        if (this.name == null || this.name.isBlank()) {
            throw new IllegalStateException("A rule needs to have a name set and the name needs to be unique");
        }
        if (this.whenFunction == null || this.whenFunction.isBlank()) {
            throw new IllegalStateException("A rule needs to have a whenFunction defined");
        }
        if (this.doFunction == null || this.doFunction.isBlank()) {
            throw new IllegalStateException("A rule needs to have a doFunction defined");
        }
        if (this.validUntil == 0L) {
            this.validUntil = System.currentTimeMillis() + 60000L;
        }
        if (this.executionCount == 0) {
            this.executionCount = 1;
        }
    }
}

