/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.jamulator;

import dev.pumpo5.core.util.ResolutionUtils;
import dev.pumpo5.remote.jamulator.JamulatorController;
import dev.pumpo5.remote.jamulator.JamulatorControllerSupport;
import dev.pumpo5.remote.jamulator.JamulatorRule;
import java.time.Duration;

public class JamulatorRuleBuilder {
    private final JamulatorControllerSupport jamulatorSupport;
    JamulatorRule rule;

    public JamulatorRuleBuilder(JamulatorControllerSupport jamulatorSupport) {
        this.jamulatorSupport = jamulatorSupport;
        this.rule = new JamulatorRule();
    }

    public JamulatorRuleBuilder withName(String name) {
        this.rule.setName(name);
        return this;
    }

    public JamulatorRuleBuilder withTimeToLive(Duration duration) {
        this.rule.setValidUntil(System.currentTimeMillis() + duration.toMillis());
        return this;
    }

    public JamulatorRuleBuilder withTotalExecutionCount(int executionCount) {
        this.rule.setExecutionCount(executionCount);
        return this;
    }

    public JamulatorRuleBuilder withWhenFunction(String whenFunction) {
        String value = ResolutionUtils.resolvePathOrString(this.jamulatorSupport.getLogger(), this, whenFunction);
        this.rule.setWhenFunction(value);
        return this;
    }

    public JamulatorRuleBuilder withDoFunction(String pathOrString) {
        String value = ResolutionUtils.resolvePathOrString(this.jamulatorSupport.getLogger(), this, pathOrString);
        this.rule.setDoFunction(value);
        return this;
    }

    public JamulatorRuleBuilder withInitFunction(String pathOrString) {
        String value = ResolutionUtils.resolvePathOrString(this.jamulatorSupport.getLogger(), this, pathOrString);
        this.rule.setInitFunction(value);
        return this;
    }

    public JamulatorRuleBuilder withFinaliseFunction(String pathOrString) {
        String value = ResolutionUtils.resolvePathOrString(this.jamulatorSupport.getLogger(), this, pathOrString);
        this.rule.setFinaliseFunction(value);
        return this;
    }

    public JamulatorRuleBuilder withStringResource(String key, String pathOrString) {
        String value = ResolutionUtils.resolvePathOrString(this.jamulatorSupport.getLogger(), this, pathOrString);
        this.rule.getResources().put(key, value);
        return this;
    }

    public JamulatorController activateRule(boolean replaceIfExists) {
        return this.jamulatorSupport.addRule(this.rule, replaceIfExists);
    }
}

