/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.kafka.KafkaAgent;
import dev.pumpo5.remote.kafka.KafkaApplication;
import dev.pumpo5.remote.kafka.KafkaListResponse;
import dev.pumpo5.remote.kafka.KafkaReadResponse;
import dev.pumpo5.remote.kafka.KafkaResponse;
import dev.pumpo5.remote.kafka.KafkaWriteResponse;
import dev.pumpo5.remote.kafka.ReadQuery;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class KafkaAgentSupport
extends AbstractRemoteDriverAgent
implements KafkaAgent {
    private static final String LIST = "kafka_list";
    private static final String CREATE = "kafka_create";
    private static final String READ = "kafka_read";
    private static final String WRITE = "kafka_write";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();
    private Integer partitionId = null;
    private static final ObjectMapper MAPPER;
    KafkaApplication kafkaApplication;
    protected String defaultConsumerGroupId;

    public KafkaAgentSupport(KafkaApplication kafkaApplication, Map<String, Object> capabilities, String farmUrl) {
        super(kafkaApplication.getLogger(), kafkaApplication.getConfig(), capabilities, farmUrl);
        this.kafkaApplication = kafkaApplication;
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    private <T extends KafkaResponse> T parseResponse(Response response, Class<T> clazz) {
        if (response == null) {
            throw new IllegalStateException("Failed to get a valid response from the remote driver");
        }
        try {
            KafkaResponse parsedResponse = (KafkaResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), clazz);
            if (parsedResponse == null) {
                parsedResponse = (KafkaResponse)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            parsedResponse.setFullResponse(response);
            parsedResponse.kafkaApplication = this.kafkaApplication;
            return (T)parsedResponse;
        }
        catch (JsonProcessingException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public KafkaListResponse listTopics() {
        Response response = this.driver.execute(LIST, null);
        return this.parseResponse(response, KafkaListResponse.class);
    }

    @Override
    public KafkaResponse createTopic(String topic) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", topic);
        Response response = this.driver.execute(CREATE, map);
        return this.parseResponse(response, KafkaResponse.class);
    }

    @Override
    public ReadQuery queryTopic(String topic) {
        return this.kafkaApplication.queryTopic(topic);
    }

    @Override
    public KafkaApplication withPartition(int partitionId) {
        this.partitionId = partitionId;
        return this.kafkaApplication;
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String message) {
        return this.write(topic, null, message, null);
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String key, String message) {
        return this.write(topic, key, message, null);
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String key, String message, Map<String, String> headers) {
        return this.write(topic, key, message, headers);
    }

    public KafkaReadResponse read(ReadQuery readQuery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topic", readQuery.topic);
        if (readQuery.partitionId != null) {
            map.put("partition", readQuery.partitionId);
        }
        if (readQuery.offset != null) {
            map.put("offset", readQuery.offset);
        }
        if (readQuery.consumerGroupId != null) {
            map.put("consumerGroupId", readQuery.consumerGroupId);
        } else if (this.defaultConsumerGroupId != null) {
            map.put("consumerGroupId", this.defaultConsumerGroupId);
        }
        if (readQuery.maxCount != null) {
            map.put("maxCount", readQuery.maxCount);
        }
        if (readQuery.tailOffsets != null) {
            map.put("tailOffsets", readQuery.tailOffsets);
        }
        if (readQuery.dateStart != null) {
            map.put("dateStart", readQuery.dateStart);
        }
        if (readQuery.dateEnd != null) {
            map.put("dateEnd", readQuery.dateEnd);
        }
        if (readQuery.headers != null) {
            map.put("headers", readQuery.headers);
        }
        Response response = this.driver.execute(READ, map);
        return this.parseResponse(response, KafkaReadResponse.class);
    }

    public KafkaWriteResponse write(String topic, String key, String message, Map<String, String> headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topic", topic);
        if (this.partitionId != null) {
            map.put("partitionId", this.partitionId);
        }
        if (key != null) {
            map.put("key", key);
        }
        if (headers != null) {
            map.put("headers", headers);
        }
        map.put("message", message);
        Response response = this.driver.execute(WRITE, map);
        return this.parseResponse(response, KafkaWriteResponse.class);
    }

    static {
        ADDITIONAL_COMMANDS.put(LIST, new CommandInfo("/session/:sessionId/kafka/list", HttpMethod.GET));
        ADDITIONAL_COMMANDS.put(CREATE, new CommandInfo("/session/:sessionId/kafka/create", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(READ, new CommandInfo("/session/:sessionId/kafka/read", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(WRITE, new CommandInfo("/session/:sessionId/kafka/write", HttpMethod.POST));
        MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

