/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.kafka;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.kafka.KafkaAgentSupport;
import dev.pumpo5.remote.kafka.KafkaApplication;
import dev.pumpo5.remote.kafka.KafkaListResponse;
import dev.pumpo5.remote.kafka.KafkaResponse;
import dev.pumpo5.remote.kafka.KafkaWriteResponse;
import dev.pumpo5.remote.kafka.ReadQuery;
import java.lang.reflect.Proxy;
import java.util.Map;

public class KafkaApplicationSupport
extends ApplicationSupport<KafkaApplication>
implements KafkaApplication {
    protected KafkaAgentSupport agent;

    public KafkaApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends KafkaApplication> APPLICATION_OBJECT createProxy(Class<? extends KafkaApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!KafkaApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend KafkaApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((KafkaApplication)Proxy.newProxyInstance(KafkaAgentSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<KafkaApplicationSupport>(type, new KafkaApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    public KafkaAgentSupport newAgent() {
        return new KafkaAgentSupport(this, this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    public KafkaApplication setDefaultConsumerGroupId(String defaultConsumerGroupId) {
        this.checkSessionStarted();
        this.agent.defaultConsumerGroupId = defaultConsumerGroupId;
        return this;
    }

    public KafkaApplication unsetDefaultConsumerGroupId() {
        this.checkSessionStarted();
        this.agent.defaultConsumerGroupId = null;
        return this;
    }

    @Override
    public KafkaListResponse listTopics() {
        this.checkSessionStarted();
        return this.agent.listTopics();
    }

    @Override
    public KafkaResponse createTopic(String topic) {
        this.checkSessionStarted();
        return this.agent.createTopic(topic);
    }

    @Override
    public ReadQuery queryTopic(String topic) {
        this.checkSessionStarted();
        return new ReadQuery(this, topic);
    }

    @Override
    public KafkaApplication withPartition(int partitionId) {
        return this.agent.withPartition(partitionId);
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String message) {
        this.checkSessionStarted();
        return this.agent.write(topic, null, message, null);
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String key, String message) {
        this.checkSessionStarted();
        return this.agent.write(topic, key, message, null);
    }

    @Override
    public KafkaWriteResponse writeMessage(String topic, String key, String message, Map<String, String> headers) {
        this.checkSessionStarted();
        return this.agent.write(topic, key, message, headers);
    }
}

