/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.kafka.KafkaMessage;
import dev.pumpo5.remote.kafka.KafkaResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KafkaReadResponse
extends KafkaResponse {
    public Collection<KafkaMessage> messages;
    private Collection<KafkaMessage> unfilteredMessages;

    public KafkaReadResponse printMessages() {
        this.messages.forEach(kafkaMessage -> this.kafkaApplication.getLogger().log(LogLevel.DEBUG, String.format("partition: %d\toffset: %d\tdate: %s\tkey: %s\tvalue: %s\theaders: %s", kafkaMessage.partition, kafkaMessage.offset, Instant.ofEpochMilli(kafkaMessage.timestamp), kafkaMessage.key, kafkaMessage.value, kafkaMessage.headers), new Object[0]));
        return this;
    }

    public KafkaReadResponse assertThatContainsMessageValue(String value) {
        Optional<KafkaMessage> optionalKafkaMessage = this.messages.stream().filter(kafkaMessage -> kafkaMessage.value.equalsIgnoreCase(value)).findAny();
        Asserts.assertTrue("no message found with value " + value, optionalKafkaMessage.isPresent());
        return this;
    }

    public KafkaReadResponse assertThatMessageCountIsAtLeast(int minCount) {
        Asserts.assertTrue("message count was not at least " + minCount + " but was " + this.messages.size(), this.messages.size() >= minCount);
        return this;
    }

    public <PoJo> KafkaReadResponse filterMessagesHavingSubstring(String substring) {
        if (this.unfilteredMessages == null) {
            this.unfilteredMessages = this.messages;
        }
        this.messages = this.messages.stream().filter(kafkaMessage -> kafkaMessage.value.contains(substring)).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    @Deprecated(forRemoval=true)
    public <PoJo> Collection<PoJo> messagesAsCollectionOf(Class<PoJo> pojoClass) {
        return this.messages.stream().map(kafkaMessage -> this.createPojoObject(pojoClass, (KafkaMessage)kafkaMessage, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public <PoJo> List<PoJo> messagesAsListOf(Class<PoJo> pojoClass) {
        return this.messages.stream().map(kafkaMessage -> this.createPojoObject(pojoClass, (KafkaMessage)kafkaMessage, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private <PoJo> Optional<PoJo> createPojoObject(Class<PoJo> pojoClass, KafkaMessage kafkaMessage, boolean reportFailure) {
        try {
            return Optional.of(MAPPER.readValue(kafkaMessage.value, pojoClass));
        }
        catch (JsonProcessingException e) {
            if (reportFailure) {
                this.kafkaApplication.getLogger().log(LogLevel.TRACE, "Cannot deserialize message as {}: {}", pojoClass.getSimpleName(), kafkaMessage.value);
            }
            return Optional.empty();
        }
    }

    public <PoJo> KafkaReadResponse filterMessagesHaving(Class<PoJo> pojoClass, Function<PoJo, Boolean> assertion) {
        if (this.unfilteredMessages == null) {
            this.unfilteredMessages = this.messages;
        }
        this.messages = this.messages.stream().filter(kafkaMessage -> {
            Optional maybePojo = this.createPojoObject(pojoClass, (KafkaMessage)kafkaMessage, false);
            if (maybePojo.isPresent()) {
                return (Boolean)assertion.apply(maybePojo.get());
            }
            return false;
        }).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    public KafkaReadResponse unfilter() {
        if (this.unfilteredMessages != null) {
            this.messages = this.unfilteredMessages;
        }
        return this;
    }
}

