/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.kafka;

import dev.pumpo5.remote.kafka.KafkaApplicationSupport;
import dev.pumpo5.remote.kafka.KafkaReadResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;

public class ReadQuery {
    protected final KafkaApplicationSupport application;
    protected String topic;
    protected Integer partitionId = null;
    protected Integer offset = null;
    protected String consumerGroupId;
    protected Integer maxCount = null;
    protected Integer tailOffsets = null;
    protected Long dateStart = null;
    protected Long dateEnd = null;
    protected Map<String, String> headers;

    public ReadQuery(KafkaApplicationSupport application, String topic) {
        this.application = application;
        this.topic = topic;
    }

    public ReadQuery onPartition(int partition) {
        this.partitionId = partition;
        return this;
    }

    public ReadQuery atOffset(int offset) {
        if (this.tailOffsets != null || this.dateStart != null || this.dateEnd != null) {
            throw new IllegalStateException("After setting other filters, specifying a specific offset does not make sense.");
        }
        this.offset = offset;
        return this;
    }

    public ReadQuery limitedToMaxMessageCountOf(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public ReadQuery forLatestPerPartitionCount(int tailOffsets) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.tailOffsets = tailOffsets;
        return this;
    }

    public ReadQuery forTimestampAfter(long millisStart) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.dateStart = millisStart;
        return this;
    }

    public ReadQuery forTimestampBefore(long millisEnd) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.dateEnd = millisEnd;
        return this;
    }

    public ReadQuery forYoungerThan(int seconds) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.dateStart = Instant.now().minus(Duration.ofSeconds(seconds)).toEpochMilli();
        return this;
    }

    public ReadQuery forOlderThan(int ageInSeconds) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.dateEnd = Instant.now().minus(Duration.ofSeconds(ageInSeconds)).toEpochMilli();
        return this;
    }

    public ReadQuery forAgedBetween(int minAgeInSeconds, int maxAgeInSeconds) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.forYoungerThan(maxAgeInSeconds);
        this.forOlderThan(minAgeInSeconds);
        return this;
    }

    public ReadQuery forTimestampBetween(long dateStart, long dateEnd) {
        if (this.offset != null) {
            throw new IllegalStateException("Because you have set a specific offset this filter does not make sense.");
        }
        this.forTimestampAfter(dateStart);
        this.forTimestampBefore(dateEnd);
        return this;
    }

    public KafkaReadResponse getMessages() {
        return this.application.agent.read(this);
    }
}

