/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.remote.mongo.MongoResponse;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bson.Document;
import org.openqa.selenium.remote.Response;

public class AggregationResponse
extends MongoResponse {
    private final Logger logger = new PumpoEvents();
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private List<Document> documents;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        try {
            this.documents = (List)MAPPER.readValue(json.at("/value/body/documents").asText(), (TypeReference)new TypeReference<List<Document>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.log(LogLevel.ERROR, "Error parsing response from remote driver: {0}", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public List<Document> getDocuments() {
        return this.documents;
    }
}

