/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.mongo.MongoResponse;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.remote.Response;

public class CommandResponse
extends MongoResponse {
    private final Logger logger = new PumpoEvents();
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private boolean isSuccessful;
    private String indexName;
    private List<String> collectionList;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.isSuccessful = json.at("/value/body/isSuccessful").asBoolean();
        this.indexName = json.at("/value/body/indexName").asText();
        String collectionListString = json.at("/value/body/collectionList").asText();
        if (collectionListString != null) {
            this.collectionList = Arrays.asList(collectionListString.split(","));
        }
    }

    public CommandResponse assertIsSuccessful() {
        Asserts.assertTrue("Command was not successful", this.isSuccessful);
        return this;
    }

    public CommandResponse assertCollectionIsPresent(String collection) {
        Asserts.assertContains(this.collectionList, collection);
        return this;
    }

    public CommandResponse assertCollectionIsNotPresent(String collection) {
        Asserts.assertDoesNotContain(this.collectionList, collection);
        return this;
    }

    public CommandResponse printCollections() {
        this.logger.log(LogLevel.INFO, "Print list of collections found:", new Object[0]);
        this.logger.log(LogLevel.INFO, "{}", String.join((CharSequence)", ", this.collectionList));
        return this;
    }

    public String getNewIndexName() {
        return this.indexName;
    }

    public CommandResponse assertNewIndexName(String expectedIndexName) {
        Asserts.assertTrue("Index name is not what was expected", expectedIndexName.equals(this.indexName));
        return this;
    }
}

