/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.mongo.MongoResponse;
import dev.pumpo5.remote.sql.TimeDeserializers;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.openqa.selenium.remote.Response;

public class DeleteResponse
extends MongoResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private long deletedCount;
    private boolean wasAcknowledged;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.deletedCount = json.at("/value/body/deletedCount").asLong();
        this.wasAcknowledged = json.at("/value/body/wasAcknowledged").asBoolean();
    }

    public DeleteResponse assertWasAcknowledged() {
        Asserts.assertTrue("delete of documents was not acknowledged", this.wasAcknowledged);
        return this;
    }

    public DeleteResponse assertDeletedCount(long expectedCount) {
        Asserts.assertEquals(expectedCount, this.deletedCount, "documents");
        return this;
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new TimeDeserializers.DateDeserializer());
        javaTimeModule.addDeserializer(Time.class, (JsonDeserializer)new TimeDeserializers.TimeDeserializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimeDeserializers.TimestampDeserializer());
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JodaModule()).registerModule((Module)javaTimeModule);
    }
}

