/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.mongo.MongoResponse;
import dev.pumpo5.remote.sql.TimeDeserializers;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.Response;

public class InsertResponse
extends MongoResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private boolean wasAcknowledged;
    private List<String> insertedIds;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.wasAcknowledged = json.at("/value/body/wasAcknowledged").asBoolean();
        this.insertedIds = this.toListOfInsertedIds(response);
    }

    private List<String> toListOfInsertedIds(Response response) {
        return StreamSupport.stream(MAPPER.valueToTree((Object)response).at("/value/body/insertedIds").spliterator(), false).map(JsonNode::toString).collect(Collectors.toList());
    }

    public InsertResponse assertWasAcknowledged() {
        Asserts.assertTrue("insertion of documents was not acknowledged", this.wasAcknowledged);
        return this;
    }

    public List<String> getInsertedIds() {
        return this.insertedIds;
    }

    public int insertedDocumentsCount() {
        return this.insertedIds.size();
    }

    public InsertResponse assertInsertedDocumentsCount(int count) {
        Asserts.assertEquals(count, this.insertedIds.size(), "inserted documents");
        return this;
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new TimeDeserializers.DateDeserializer());
        javaTimeModule.addDeserializer(Time.class, (JsonDeserializer)new TimeDeserializers.TimeDeserializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimeDeserializers.TimestampDeserializer());
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JodaModule()).registerModule((Module)javaTimeModule);
    }
}

