/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.webdriver.AbstractRemoteDriverAgent;
import dev.pumpo5.remote.mongo.AggregationResponse;
import dev.pumpo5.remote.mongo.CommandResponse;
import dev.pumpo5.remote.mongo.DeleteResponse;
import dev.pumpo5.remote.mongo.InsertResponse;
import dev.pumpo5.remote.mongo.MongoAgent;
import dev.pumpo5.remote.mongo.MongoApplication;
import dev.pumpo5.remote.mongo.MongoResponse;
import dev.pumpo5.remote.mongo.QueryResponse;
import dev.pumpo5.remote.mongo.UpdateResponse;
import dev.pumpo5.remote.mongo.enums.CommandType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;

public class MongoAgentSupport
extends AbstractRemoteDriverAgent
implements MongoAgent {
    private static final String QUERY = "mongo_query";
    private static final String UPDATE = "mongo_update";
    private static final Map<String, CommandInfo> ADDITIONAL_COMMANDS = new HashMap<String, CommandInfo>();
    private static final ObjectMapper MAPPER;
    MongoApplication mongoApplication;

    public MongoAgentSupport(MongoApplication mongoApplication, Map<String, Object> capabilities, String farmUrl) {
        super(mongoApplication.getLogger(), mongoApplication.getConfig(), capabilities, farmUrl);
        this.mongoApplication = mongoApplication;
    }

    @Override
    protected Map<String, CommandInfo> getAdditionalCommands() {
        return ADDITIONAL_COMMANDS;
    }

    @Override
    public QueryResponse query(String query, Map<String, String> options, String collection) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "query");
        params.put("query", query);
        params.put("collection", collection);
        params.put("options", options.toString());
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, QueryResponse.class);
    }

    @Override
    public UpdateResponse update(String filter, String update, Map<String, String> options, String collection, boolean updateMany) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "update");
        params.put("update", update);
        params.put("filter", filter);
        params.put("options", options.toString());
        params.put("updateMany", String.valueOf(updateMany));
        params.put("collection", collection);
        Response response = this.driver.execute(UPDATE, params);
        return this.parseResponse(response, UpdateResponse.class);
    }

    @Override
    public InsertResponse insert(List<String> documentList, String collection, Map<String, String> options) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "insert");
        params.put("insert", documentList.toString());
        params.put("collection", collection);
        params.put("options", options.toString());
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, InsertResponse.class);
    }

    @Override
    public DeleteResponse delete(String filter, String collection, boolean deleteMany, Map<String, String> options) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "delete");
        params.put("delete", filter);
        params.put("collection", collection);
        params.put("deleteMany", String.valueOf(deleteMany));
        params.put("options", options.toString());
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, DeleteResponse.class);
    }

    @Override
    public AggregationResponse aggregate(List<String> pipeline, String collection) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", "aggregate");
        params.put("aggregate", pipeline.toString());
        params.put("collection", collection);
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, AggregationResponse.class);
    }

    @Override
    public CommandResponse command(CommandType commandType, String collection, String newIndex, Map<String, String> options, String indexName, long dropIndexMaxTime) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("queryType", commandType.toString());
        params.put("collection", collection);
        params.put("newIndex", newIndex);
        params.put("options", options.toString());
        params.put("indexName", indexName);
        params.put("dropIndexMaxTime", String.valueOf(dropIndexMaxTime));
        Response response = this.driver.execute(QUERY, params);
        return this.parseResponse(response, CommandResponse.class);
    }

    private <T extends MongoResponse> T parseResponse(Response response, Class<T> clazz) {
        if (response == null) {
            throw new IllegalStateException("Failed to get a valid response from the remote driver");
        }
        try {
            MongoResponse parsedResponse = (MongoResponse)MAPPER.treeToValue((TreeNode)MAPPER.valueToTree(response.getValue()), clazz);
            parsedResponse.setFullResponse(response);
            parsedResponse.mongoApplication = this.mongoApplication;
            return (T)parsedResponse;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ADDITIONAL_COMMANDS.put(QUERY, new CommandInfo("/session/:sessionId/pn5-mongo/execute", HttpMethod.POST));
        ADDITIONAL_COMMANDS.put(UPDATE, new CommandInfo("/session/:sessionId/pn5-mongo/execute", HttpMethod.POST));
        MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

