/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import dev.pumpo5.core.CoreAccessor;
import dev.pumpo5.core.SessionManager;
import dev.pumpo5.core.webdriver.ApplicationProxyInvocationHandler;
import dev.pumpo5.core.webdriver.ApplicationSupport;
import dev.pumpo5.core.webdriver.RemoteDriverAgent;
import dev.pumpo5.remote.mongo.AggregationResponse;
import dev.pumpo5.remote.mongo.CommandResponse;
import dev.pumpo5.remote.mongo.DeleteResponse;
import dev.pumpo5.remote.mongo.InsertResponse;
import dev.pumpo5.remote.mongo.MongoAgentSupport;
import dev.pumpo5.remote.mongo.MongoApplication;
import dev.pumpo5.remote.mongo.MongoReporter;
import dev.pumpo5.remote.mongo.QueryResponse;
import dev.pumpo5.remote.mongo.UpdateResponse;
import dev.pumpo5.remote.mongo.builders.AggregationBuilder;
import dev.pumpo5.remote.mongo.builders.CommandBuilder;
import dev.pumpo5.remote.mongo.builders.DeleteBuilder;
import dev.pumpo5.remote.mongo.builders.InsertBuilder;
import dev.pumpo5.remote.mongo.builders.QueryBuilder;
import dev.pumpo5.remote.mongo.builders.UpdateBuilder;
import dev.pumpo5.remote.mongo.enums.CommandType;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class MongoApplicationSupport
extends ApplicationSupport<MongoApplication>
implements MongoApplication,
SessionManager<MongoApplication> {
    protected MongoAgentSupport agent;
    protected MongoReporter mongoReporter;

    public MongoApplicationSupport(CoreAccessor core, String driverUrl, Map<String, Object> capabilities) {
        super(core, driverUrl, capabilities);
    }

    public static <APPLICATION_OBJECT extends MongoApplication> APPLICATION_OBJECT createProxy(Class<? extends MongoApplication> type, String driverUrl, Map<String, Object> capabilities, CoreAccessor core) {
        String parameterTypeName = type.getSimpleName();
        if (!MongoApplication.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s type must extend MongoApplication", parameterTypeName));
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.format("%s type must be an interface", parameterTypeName));
        }
        return (APPLICATION_OBJECT)((MongoApplication)Proxy.newProxyInstance(MongoAgentSupport.class.getClassLoader(), new Class[]{type}, new ApplicationProxyInvocationHandler<MongoApplicationSupport>(type, new MongoApplicationSupport(core, driverUrl, capabilities))));
    }

    @Override
    public MongoAgentSupport newAgent() {
        return new MongoAgentSupport(this, this.capabilities, this.driverUrl);
    }

    @Override
    public RemoteDriverAgent agent() {
        return this.agent;
    }

    @Override
    protected void startSessionImplementation() {
        this.agent = this.newAgent();
    }

    @Override
    protected void closeSessionImplementation() {
        if (this.agent != null) {
            this.attemptClosingSession(this.agent);
            this.agent = null;
        }
    }

    @Override
    public QueryBuilder prepareQuery(String collection) {
        return new QueryBuilder(this, collection);
    }

    @Override
    public UpdateBuilder prepareUpdate(String collection) {
        return new UpdateBuilder(this, collection);
    }

    @Override
    public InsertBuilder prepareInsert(String collection) {
        return new InsertBuilder(this, collection);
    }

    @Override
    public DeleteBuilder prepareDelete(String collection) {
        return new DeleteBuilder(this, collection);
    }

    @Override
    public AggregationBuilder prepareAggregate(String collection) {
        return new AggregationBuilder(this, collection);
    }

    @Override
    public CommandBuilder prepareCommand() {
        return new CommandBuilder(this);
    }

    public QueryResponse query(String query, Map<String, String> options, String collection) {
        this.checkSessionStarted();
        try {
            QueryResponse selectResponse = this.agent.query(query, options, collection);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportQuery(query, options, selectResponse);
            }
            return selectResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportQuery(query, options, null);
            }
            throw t;
        }
    }

    public UpdateResponse update(String filter, String update, Map<String, String> options, String collection, boolean updateMany) {
        this.checkSessionStarted();
        try {
            UpdateResponse updateResponse = this.agent.update(filter, update, options, collection, updateMany);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportUpdate(filter, update, options, updateMany, updateResponse);
            }
            return updateResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportUpdate(filter, update, options, updateMany, null);
            }
            throw t;
        }
    }

    public InsertResponse insert(List<String> documentList, String collection, Map<String, String> options) {
        this.checkSessionStarted();
        try {
            InsertResponse insertResponse = this.agent.insert(documentList, collection, options);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportInsert(documentList, options, insertResponse);
            }
            return insertResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportInsert(documentList, options, null);
            }
            throw t;
        }
    }

    public DeleteResponse delete(String filter, String collection, boolean deleteMany, Map<String, String> options) {
        this.checkSessionStarted();
        try {
            DeleteResponse deleteResponse = this.agent.delete(filter, collection, deleteMany, options);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportDelete(filter, collection, deleteMany, options, deleteResponse);
            }
            return deleteResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportDelete(filter, collection, deleteMany, options, null);
            }
            throw t;
        }
    }

    public AggregationResponse aggregate(List<String> pipeline, String collection) {
        this.checkSessionStarted();
        try {
            AggregationResponse aggregationResponse = this.agent.aggregate(pipeline, collection);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportAggregate(pipeline, aggregationResponse);
            }
            return aggregationResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportAggregate(pipeline, null);
            }
            throw t;
        }
    }

    public CommandResponse command(CommandType commandType, String collection, String newIndex, Map<String, String> options, String indexName, long dropIndexMaxTime) {
        this.checkSessionStarted();
        try {
            CommandResponse commandResponse = this.agent.command(commandType, collection, newIndex, options, indexName, dropIndexMaxTime);
            if (this.mongoReporter != null) {
                this.mongoReporter.reportCommand(commandType, collection, newIndex, options, indexName, dropIndexMaxTime, commandResponse);
            }
            return commandResponse;
        }
        catch (Throwable t) {
            if (this.mongoReporter != null) {
                this.mongoReporter.reportCommand(commandType, collection, newIndex, options, indexName, dropIndexMaxTime, null);
            }
            throw t;
        }
    }
}

