/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.LogLevel;
import dev.pumpo5.core.Logger;
import dev.pumpo5.core.PumpoEvents;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.mongo.MongoResponse;
import dev.pumpo5.remote.sql.TimeDeserializers;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bson.Document;
import org.openqa.selenium.remote.Response;

public class QueryResponse
extends MongoResponse {
    private final Logger logger = new PumpoEvents();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private long rowCount;
    private List<Document> documents;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        try {
            this.documents = (List)MAPPER.readValue(json.at("/value/body/documents").asText(), (TypeReference)new TypeReference<List<Document>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.log(LogLevel.ERROR, "Error parsing response from remote driver: {0}", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public int getDocumentsCount() {
        return this.documents.size();
    }

    public <PoJo> List<PoJo> getDocumentsAs(Class<PoJo> pojoClass) {
        return this.documents.stream().map(row -> {
            try {
                return MAPPER.readValue(row.toJson(), pojoClass);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }

    public QueryResponse assertDocumentsCount(long expected) {
        Asserts.assertEquals(expected, (long)this.documents.size(), "documents");
        return this;
    }

    public QueryResponse printDocuments() {
        List listOfJson = this.documents.stream().map(Document::toJson).collect(Collectors.toList());
        this.logger.log("Print documents returned from query: \n", new Object[0]);
        for (int i = 0; i < listOfJson.size(); ++i) {
            this.logger.log(LogLevel.INFO, "Document {}: {}\n", i + 1, listOfJson.get(i));
        }
        return this;
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new TimeDeserializers.DateDeserializer());
        javaTimeModule.addDeserializer(Time.class, (JsonDeserializer)new TimeDeserializers.TimeDeserializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimeDeserializers.TimestampDeserializer());
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JodaModule()).registerModule((Module)javaTimeModule);
    }
}

