/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.pumpo5.core.util.Asserts;
import dev.pumpo5.remote.mongo.MongoResponse;
import org.junit.Assert;
import org.openqa.selenium.remote.Response;

public class UpdateResponse
extends MongoResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private boolean wasAcknowledged;
    private String upsertedId;
    private long matchedDocumentsCount;
    private long modifiedDocumentsCount;

    @Override
    protected void setFullResponse(Response response) {
        this.fullResponse = response;
        JsonNode json = MAPPER.valueToTree((Object)response);
        this.wasAcknowledged = json.at("/value/body/wasAcknowledged").asBoolean();
        this.upsertedId = json.at("/value/body/upsertedId").toString();
        this.matchedDocumentsCount = json.at("/value/body/matchedDocuments").asLong();
        this.modifiedDocumentsCount = json.at("/value/body/modifiedDocuments").asLong();
    }

    public UpdateResponse assertWasAcknowledged() {
        Asserts.assertTrue("update of documents was not acknowledged", this.wasAcknowledged);
        return this;
    }

    public UpdateResponse assertMatchedCount(long expectedCount) {
        Asserts.assertEquals(expectedCount, this.matchedDocumentsCount, "documents");
        return this;
    }

    public UpdateResponse assertModifiedCount(long expectedCount) {
        Asserts.assertEquals(expectedCount, this.modifiedDocumentsCount, "documents");
        return this;
    }

    public String getUpsertedId() {
        return this.upsertedId;
    }

    public UpdateResponse assertDocumentWasUpserted() {
        Assert.assertNotNull((Object)this.upsertedId);
        return this;
    }
}

