/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import dev.pumpo5.remote.mongo.AggregationResponse;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class AggregationBuilder {
    protected final MongoApplicationSupport application;
    private final String collection;
    private final List<String> pipeline;

    public AggregationBuilder(MongoApplicationSupport application, String collection) {
        this.application = application;
        this.collection = collection;
        this.pipeline = new ArrayList<String>();
    }

    public AggregationBuilder lookup(Document lookup) {
        this.pipeline.add(new Document("$lookup", (Object)lookup).toJson());
        return this;
    }

    public AggregationBuilder match(Document filter) {
        this.pipeline.add(new Document("$match", (Object)filter).toJson());
        return this;
    }

    public AggregationBuilder project(Document projection) {
        this.pipeline.add(new Document("$project", (Object)projection).toJson());
        return this;
    }

    public AggregationBuilder group(Document group) {
        this.pipeline.add(new Document("$group", (Object)group).toJson());
        return this;
    }

    public AggregationBuilder sort(Document sort) {
        this.pipeline.add(new Document("$sort", (Object)sort).toJson());
        return this;
    }

    public AggregationResponse execute() {
        return this.application.aggregate(this.pipeline, this.collection);
    }
}

