/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.IndexOptions;
import dev.pumpo5.remote.mongo.CommandResponse;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import dev.pumpo5.remote.mongo.enums.CommandType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

public class CommandBuilder {
    private final MongoApplicationSupport application;
    private CommandType commandType;
    private String collection;
    private String newIndex;
    private String indexName;
    private IndexOptions options = new IndexOptions();
    private DropIndexOptions dropIndexOptions = new DropIndexOptions();

    public CommandBuilder(MongoApplicationSupport application) {
        this.application = application;
    }

    public CommandBuilder createCollection(String collection) {
        this.commandType = CommandType.CREATE_COLLECTION;
        this.collection = collection;
        return this;
    }

    public CommandBuilder dropCollection(String collection) {
        this.commandType = CommandType.DROP_COLLECTION;
        this.collection = collection;
        return this;
    }

    public CommandBuilder listCollections() {
        this.commandType = CommandType.LIST_COLLECTION;
        return this;
    }

    public CommandBuilder dropDatabase() {
        this.commandType = CommandType.DROP_DATABASE;
        return this;
    }

    public CommandBuilder createIndex(String collection, Document newIndex, IndexOptions options) {
        this.commandType = CommandType.CREATE_INDEX;
        this.collection = collection;
        this.newIndex = newIndex.toJson();
        this.options = options;
        return this;
    }

    public CommandBuilder dropIndex(String collection, String indexName, DropIndexOptions dropIndexOptions) {
        this.commandType = CommandType.DROP_INDEX;
        this.collection = collection;
        this.indexName = indexName;
        this.dropIndexOptions = dropIndexOptions;
        return this;
    }

    public CommandResponse execute() {
        return this.application.command(this.commandType, this.collection, this.newIndex, this.serializeOptions(), this.indexName, this.dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    private Map<String, String> serializeOptions() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("background", String.valueOf(this.options.isBackground()));
        optionsMap.put("unique", String.valueOf(this.options.isUnique()));
        optionsMap.put("hidden", String.valueOf(this.options.isHidden()));
        optionsMap.put("sparse", String.valueOf(this.options.isSparse()));
        optionsMap.put("name", this.options.getName());
        optionsMap.put("defaultLanguage", this.options.getDefaultLanguage());
        optionsMap.put("collation", this.options.getCollation() == null ? null : this.options.getCollation().asDocument().toJson());
        optionsMap.put("languageOverride", this.options.getLanguageOverride());
        optionsMap.put("bits", String.valueOf(this.options.getBits()));
        optionsMap.put("partialFilterExpression", this.options.getPartialFilterExpression() == null ? null : this.options.getPartialFilterExpression().toBsonDocument().toJson());
        optionsMap.put("sphereVersion", String.valueOf(this.options.getSphereVersion()));
        optionsMap.put("textVersion", String.valueOf(this.options.getTextVersion()));
        optionsMap.put("version", String.valueOf(this.options.getVersion()));
        optionsMap.put("max", String.valueOf(this.options.getMax()));
        optionsMap.put("min", String.valueOf(this.options.getMin()));
        optionsMap.put("storageEngine", this.options.getStorageEngine() == null ? null : this.options.getStorageEngine().toBsonDocument().toJson());
        optionsMap.put("weights", this.options.getWeights() == null ? null : this.options.getWeights().toBsonDocument().toJson());
        optionsMap.put("wildcardProjection", this.options.getWildcardProjection() == null ? null : this.options.getWildcardProjection().toBsonDocument().toJson());
        return optionsMap;
    }
}

