/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOptions;
import dev.pumpo5.remote.mongo.DeleteResponse;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class DeleteBuilder {
    private final MongoApplicationSupport application;
    private final String collection;
    private final DeleteOptions options;
    private Document filter;
    private Document hint;
    private Document variables;
    private boolean deleteMany = false;

    public DeleteBuilder(MongoApplicationSupport application, String collection) {
        this.application = application;
        this.collection = collection;
        this.filter = new Document();
        this.options = new DeleteOptions();
        this.hint = new Document();
        this.variables = new Document();
    }

    public DeleteBuilder filter(Document filter) {
        this.filter.putAll((Map)filter);
        return this;
    }

    public DeleteBuilder filter(String key, Object value) {
        this.filter.put(key, value);
        return this;
    }

    public DeleteBuilder deleteMany(boolean deleteMany) {
        this.deleteMany = deleteMany;
        return this;
    }

    public DeleteBuilder comment(String comment) {
        this.options.comment(comment);
        return this;
    }

    public DeleteBuilder hint(Document hint) {
        this.hint.putAll((Map)hint);
        return this;
    }

    public DeleteBuilder hint(String key, Object value) {
        this.hint.put(key, value);
        return this;
    }

    public DeleteBuilder hintString(String hintString) {
        this.options.hintString(hintString);
        return this;
    }

    public DeleteBuilder let(Document variables) {
        this.variables.putAll((Map)variables);
        return this;
    }

    public DeleteBuilder let(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public DeleteBuilder collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }

    public DeleteResponse execute() {
        return this.application.delete(this.filter.toJson(), this.collection, this.deleteMany, this.serializeOptions());
    }

    private Map<String, String> serializeOptions() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("collation", this.options.getCollation() == null ? null : this.options.getCollation().asDocument().toJson());
        optionsMap.put("hintString", this.options.getHintString());
        optionsMap.put("hint", this.hint.isEmpty() ? null : this.hint.toJson());
        optionsMap.put("comment", this.options.getComment() == null ? null : this.options.getComment().toString());
        optionsMap.put("variables", this.variables.isEmpty() ? null : this.variables.toJson());
        return optionsMap;
    }
}

