/*
 * Decompiled with CFR 0.152.
 */
package dev.pumpo5.remote.mongo.builders;

import com.mongodb.client.model.InsertManyOptions;
import dev.pumpo5.remote.mongo.InsertResponse;
import dev.pumpo5.remote.mongo.MongoApplicationSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class InsertBuilder {
    private final MongoApplicationSupport application;
    private final String collection;
    private final List<String> documents;
    private final InsertManyOptions options;

    public InsertBuilder(MongoApplicationSupport application, String collection) {
        this.application = application;
        this.collection = collection;
        this.documents = new ArrayList<String>();
        this.options = new InsertManyOptions();
    }

    public InsertBuilder addDocument(Document document) {
        this.documents.add(document.toJson());
        return this;
    }

    public InsertBuilder addDocuments(List<Document> documents) {
        for (Document document : documents) {
            this.documents.add(document.toJson());
        }
        return this;
    }

    public InsertBuilder comment(String comment) {
        this.options.comment(comment);
        return this;
    }

    public InsertBuilder bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.options.bypassDocumentValidation(Boolean.valueOf(bypassDocumentValidation));
        return this;
    }

    public InsertBuilder isOrdered(boolean isOrdered) {
        this.options.ordered(isOrdered);
        return this;
    }

    public InsertResponse execute() {
        return this.application.insert(this.documents, this.collection, this.serializeOptions());
    }

    private Map<String, String> serializeOptions() {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("comment", this.options.getComment() == null ? null : this.options.getComment().asString().getValue());
        optionsMap.put("bypassDocumentValidation", String.valueOf(this.options.getBypassDocumentValidation()));
        optionsMap.put("isOrdered", String.valueOf(this.options.isOrdered()));
        return optionsMap;
    }
}

